import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["iconType", "alwaysShow", "className", "isDisabled", "parentIsDisabled", "color"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { EuiButtonIcon } from '../button';
import { useEuiTheme } from '../../services';
import { euiListGroupItemExtraActionStyles } from './list_group_item_extra_action.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiListGroupItemExtraAction = function EuiListGroupItemExtraAction(_ref) {
  var iconType = _ref.iconType,
    alwaysShow = _ref.alwaysShow,
    className = _ref.className,
    isDisabled = _ref.isDisabled,
    parentIsDisabled = _ref.parentIsDisabled,
    color = _ref.color,
    rest = _objectWithoutProperties(_ref, _excluded);
  var extraActionClasses = classNames('euiListGroupItemExtraAction', className);
  var euiTheme = useEuiTheme();
  var extraActionStyles = euiListGroupItemExtraActionStyles(euiTheme);
  var cssExtraActionStyles = [extraActionStyles.euiListGroupItemExtraAction, alwaysShow && extraActionStyles.alwaysShow, !alwaysShow && !parentIsDisabled && extraActionStyles.hoverStyles];
  return ___EmotionJSX(EuiButtonIcon, _extends({
    color: color,
    className: extraActionClasses,
    css: cssExtraActionStyles,
    iconType: iconType,
    disabled: isDisabled || parentIsDisabled
  }, rest));
};