import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "listItems", "pinTitle", "unpinTitle", "onPinClick"],
  _excluded2 = ["pinned", "pinnable"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { EuiI18n } from '../../i18n';
import { EuiListGroup } from '../list_group';
import { useEuiTheme } from '../../../services';
import { euiPinnableListGroupItemExtraActionStyles } from './pinnable_list_group.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiPinnableListGroup = function EuiPinnableListGroup(_ref) {
  var className = _ref.className,
    listItems = _ref.listItems,
    pinTitle = _ref.pinTitle,
    unpinTitle = _ref.unpinTitle,
    onPinClick = _ref.onPinClick,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiPinnableListGroup', className);
  var euiTheme = useEuiTheme();
  var itemExtraActionStyles = euiPinnableListGroupItemExtraActionStyles(euiTheme);
  var pinExtraAction = {
    iconType: 'pinFilled',
    iconSize: 's',
    css: itemExtraActionStyles.euiPinnableListGroup__itemExtraAction
  };
  var pinnedExtraAction = {
    iconType: 'pinFilled',
    iconSize: 's',
    css: [itemExtraActionStyles.euiPinnableListGroup__itemExtraAction, itemExtraActionStyles.pinned],
    alwaysShow: true
  };

  // Alter listItems object with extra props
  var getNewListItems = function getNewListItems(pinExtraActionLabel, pinnedExtraActionLabel) {
    return listItems.map(function (item) {
      var pinned = item.pinned,
        _item$pinnable = item.pinnable,
        pinnable = _item$pinnable === void 0 ? true : _item$pinnable,
        itemProps = _objectWithoutProperties(item, _excluded2);
      // Make some declarations of props for the nav implementation
      itemProps.className = classNames('euiPinnableListGroup__item', item.className);

      // Add the pinning action unless the item has it's own extra action
      if (pinnable && !itemProps.extraAction) {
        // Different displays for pinned vs unpinned
        if (pinned) {
          itemProps.extraAction = _objectSpread(_objectSpread({}, pinnedExtraAction), {}, {
            title: unpinTitle ? unpinTitle(item) : pinnedExtraActionLabel,
            'aria-label': unpinTitle ? unpinTitle(item) : pinnedExtraActionLabel
          });
        } else {
          itemProps.extraAction = _objectSpread(_objectSpread({}, pinExtraAction), {}, {
            title: pinTitle ? pinTitle(item) : pinExtraActionLabel,
            'aria-label': pinTitle ? pinTitle(item) : pinExtraActionLabel
          });
        }
        // Return the item on click
        itemProps.extraAction.onClick = function () {
          return onPinClick(item);
        };
      }
      return itemProps;
    });
  };
  return ___EmotionJSX(EuiI18n, {
    tokens: ['euiPinnableListGroup.pinExtraActionLabel', 'euiPinnableListGroup.pinnedExtraActionLabel'],
    defaults: ['Pin item', 'Unpin item']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      pinExtraActionLabel = _ref3[0],
      pinnedExtraActionLabel = _ref3[1];
    var newListItems = getNewListItems(pinExtraActionLabel, pinnedExtraActionLabel);
    return ___EmotionJSX(EuiListGroup, _extends({
      className: classes,
      listItems: newListItems
    }, rest));
  });
};