import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["size", "mono", "className", "aria-label"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { useLoadingAriaLabel } from './_loading_strings';
import { euiLoadingChartStyles, euiLoadingChartBarStyles, BARS_COUNT } from './loading_chart.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['m', 'l', 'xl'];
export var EuiLoadingChart = function EuiLoadingChart(_ref) {
  var _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$mono = _ref.mono,
    mono = _ref$mono === void 0 ? false : _ref$mono,
    className = _ref.className,
    ariaLabel = _ref['aria-label'],
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiLoadingChart', className);
  var styles = useEuiMemoizedStyles(euiLoadingChartStyles);
  var cssStyles = [styles.euiLoadingChart, styles[size]];
  var barStyles = useEuiMemoizedStyles(euiLoadingChartBarStyles);
  var barCssStyles = [barStyles.euiLoadingChart__bar, mono ? barStyles.mono : barStyles.nonmono, barStyles[size]];
  var defaultAriaLabel = useLoadingAriaLabel();
  return ___EmotionJSX("span", _extends({
    className: classes,
    css: cssStyles,
    role: "progressbar",
    "aria-label": ariaLabel || defaultAriaLabel
  }, rest), Array.from({
    length: BARS_COUNT
  }, function (_, index) {
    return ___EmotionJSX("span", {
      key: index,
      css: barCssStyles
    });
  }));
};