import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["size", "logo", "aria-label", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiIcon } from '../icon';
import { useLoadingAriaLabel } from './_loading_strings';
import { euiLoadingLogoStyles } from './loading_logo.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['m', 'l', 'xl'];
export var EuiLoadingLogo = function EuiLoadingLogo(_ref) {
  var _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$logo = _ref.logo,
    logo = _ref$logo === void 0 ? 'logoKibana' : _ref$logo,
    ariaLabel = _ref['aria-label'],
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiLoadingLogo', className);
  var styles = useEuiMemoizedStyles(euiLoadingLogoStyles);
  var cssStyles = [styles.euiLoadingLogo, styles[size]];
  var defaultLabel = useLoadingAriaLabel();
  return ___EmotionJSX("span", _extends({
    className: classes,
    css: cssStyles,
    role: "progressbar",
    "aria-label": ariaLabel || defaultLabel
  }, rest), ___EmotionJSX("span", {
    css: styles.euiLoadingLogo__icon
  }, ___EmotionJSX(EuiIcon, {
    type: logo,
    size: size
  })));
};