import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["size", "className", "aria-label", "color", "style"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiTheme, useEuiMemoizedStyles } from '../../services';
import { useLoadingAriaLabel } from './_loading_strings';
import { euiLoadingSpinnerStyles, euiSpinnerBorderColorsCSS } from './loading_spinner.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['s', 'm', 'l', 'xl', 'xxl'];
export var EuiLoadingSpinner = function EuiLoadingSpinner(_ref) {
  var _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    className = _ref.className,
    ariaLabel = _ref['aria-label'],
    color = _ref.color,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiLoadingSpinner', className);
  var styles = useEuiMemoizedStyles(euiLoadingSpinnerStyles);
  var cssStyles = [styles.euiLoadingSpinner, styles[size]];
  var euiTheme = useEuiTheme();
  var customColorStyle = color ? _objectSpread(_objectSpread({}, style), {}, {
    borderColor: euiSpinnerBorderColorsCSS(euiTheme, color)
  }) : style;
  var defaultLabel = useLoadingAriaLabel();
  return ___EmotionJSX("span", _extends({
    className: classes,
    css: cssStyles,
    style: customColorStyle,
    role: "progressbar",
    "aria-label": ariaLabel || defaultLabel
  }, rest));
};