import _taggedTemplateLiteral from "@babel/runtime/helpers/taggedTemplateLiteral";
var _templateObject;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css, keyframes } from '@emotion/react';
import { euiCanAnimate, logicalSizeCSS, logicalShorthandCSS, mathWithUnits } from '../../global_styling';
var _loadingSpinner = keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  from {\n    transform: rotate(0deg);\n  }\n\n  to {\n    transform: rotate(359deg);\n  }\n"])));
var spinnerSizes = {
  s: 'm',
  m: 'base',
  l: 'l',
  xl: 'xl',
  xxl: 'xxl'
};
export var euiSpinnerBorderColorsCSS = function euiSpinnerBorderColorsCSS(_ref) {
  var euiTheme = _ref.euiTheme;
  var colors = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _colors$border = colors.border,
    border = _colors$border === void 0 ? euiTheme.colors.lightShade : _colors$border,
    _colors$highlight = colors.highlight,
    highlight = _colors$highlight === void 0 ? euiTheme.colors.primary : _colors$highlight;
  return "".concat(highlight, " ").concat(border, " ").concat(border, " ").concat(border);
};
export var euiLoadingSpinnerStyles = function euiLoadingSpinnerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiLoadingSpinner: /*#__PURE__*/css("flex-shrink:0;display:inline-block;border-radius:50%;border:", euiTheme.border.thick, ";", logicalShorthandCSS('border-color', euiSpinnerBorderColorsCSS(euiThemeContext)), " ", euiCanAnimate, "{animation:", _loadingSpinner, " 0.6s infinite linear;};label:euiLoadingSpinner;"),
    // Sizes
    s: /*#__PURE__*/css(logicalSizeCSS(euiTheme.size[spinnerSizes.s], euiTheme.size[spinnerSizes.s]), " border-width:", mathWithUnits(euiTheme.border.width.thin, function (x) {
      return x * 1.5;
    }), ";;label:s;"),
    m: /*#__PURE__*/css(logicalSizeCSS(euiTheme.size[spinnerSizes.m], euiTheme.size[spinnerSizes.m]), " border-width:", mathWithUnits(euiTheme.border.width.thin, function (x) {
      return x * 1.5;
    }), ";;label:m;"),
    l: /*#__PURE__*/css(logicalSizeCSS(euiTheme.size[spinnerSizes.l], euiTheme.size[spinnerSizes.l]), ";;label:l;"),
    xl: /*#__PURE__*/css(logicalSizeCSS(euiTheme.size[spinnerSizes.xl], euiTheme.size[spinnerSizes.xl]), ";;label:xl;"),
    xxl: /*#__PURE__*/css(logicalSizeCSS(euiTheme.size[spinnerSizes.xxl], euiTheme.size[spinnerSizes.xxl]), ";;label:xxl;")
  };
};