import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "hasScreenReaderHelpText"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { useEuiI18n } from '../i18n';
import { euiMarkStyles, euiMarkScreenReaderStyles } from './mark.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiMark = function EuiMark(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$hasScreenReaderH = _ref.hasScreenReaderHelpText,
    hasScreenReaderHelpText = _ref$hasScreenReaderH === void 0 ? true : _ref$hasScreenReaderH,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiMark', className);
  var styles = useEuiMemoizedStyles(euiMarkStyles);
  var highlightStart = useEuiI18n('euiMark.highlightStart', 'highlight start');
  var highlightEnd = useEuiI18n('euiMark.highlightEnd', 'highlight end');
  var screenReaderStyles = useMemo(function () {
    return euiMarkScreenReaderStyles(highlightStart, highlightEnd);
  }, [highlightStart, highlightEnd]);
  var cssStyles = [styles.euiMark, hasScreenReaderHelpText && screenReaderStyles.hasScreenReaderHelpText];
  return ___EmotionJSX("mark", _extends({
    css: cssStyles,
    className: classes
  }, rest), children);
};