/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../global_styling';
import { euiMarkdownEditorVariables } from './markdown_editor.styles';
export var euiMarkdownEditorFooterStyles = function euiMarkdownEditorFooterStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiMarkdownEditorVar = euiMarkdownEditorVariables(euiThemeContext),
    borderRadius = _euiMarkdownEditorVar.borderRadius,
    barsBackgroundColor = _euiMarkdownEditorVar.barsBackgroundColor;
  return {
    euiMarkdownEditorFooter: /*#__PURE__*/css("display:inline-flex;align-items:center;padding:", euiTheme.size.xs, ";border:", euiTheme.border.thin, ";background-color:", barsBackgroundColor, ";;label:euiMarkdownEditorFooter;"),
    euiMarkdownEditorFooter__actions: /*#__PURE__*/css("flex:1;display:inline-flex;align-items:center;gap:", euiTheme.size.xs, ";;label:euiMarkdownEditorFooter__actions;"),
    // Override default button border radius to match the overall markdown editor
    euiMarkdownEditorFooter__uploadError: /*#__PURE__*/css("border-radius:", borderRadius, ";;label:euiMarkdownEditorFooter__uploadError;"),
    // Override the default button icon width size
    euiMarkdownEditorFooter__helpButton: /*#__PURE__*/css(".euiIcon{", logicalCSS('width', '26px'), ";};label:euiMarkdownEditorFooter__helpButton;"),
    euiMarkdownEditorFooter__popover: /*#__PURE__*/css(logicalCSS('width', '300px'), ";;label:euiMarkdownEditorFooter__popover;")
  };
};