/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../global_styling';
import { euiMarkdownEditorVariables } from './markdown_editor.styles';
export var euiMarkdownEditorToolbarStyles = function euiMarkdownEditorToolbarStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiMarkdownEditorVar = euiMarkdownEditorVariables(euiThemeContext),
    barsBackgroundColor = _euiMarkdownEditorVar.barsBackgroundColor;
  return {
    euiMarkdownEditorToolbar: /*#__PURE__*/css("display:flex;flex-wrap:wrap;padding:", euiTheme.size.xs, ";background-color:", barsBackgroundColor, ";border:", euiTheme.border.thin, ";", logicalCSS('border-bottom', 'none'), ";;label:euiMarkdownEditorToolbar;"),
    euiMarkdownEditorToolbar__buttons: /*#__PURE__*/css("flex:1;display:flex;flex-wrap:wrap;align-items:center;column-gap:", euiTheme.size.xs, ";;label:euiMarkdownEditorToolbar__buttons;"),
    euiMarkdownEditorToolbar__divider: /*#__PURE__*/css("display:block;", logicalCSS('height', euiTheme.size.l), " ", logicalCSS('margin-left', euiTheme.size.xs), " ", logicalCSS('padding-right', euiTheme.size.xs), " ", logicalCSS('border-left', "".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.border.color)), ";;label:euiMarkdownEditorToolbar__divider;")
  };
};