import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["exclude"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Importing seemingly unused types from `unified` because the definitions
// are exported for two versions of TypeScript (3.4, 4.0) and implicit
// imports during eui.d.ts generation default to the incorrect version (3.4).
// Explicit imports here resolve the version mismatch.

import markdown from 'remark-parse-no-trim';
import emoji from 'remark-emoji';
import breaks from 'remark-breaks';
import highlight from '../remark/remark_prismjs';
import * as MarkdownTooltip from '../markdown_tooltip';
import * as MarkdownCheckbox from '../markdown_checkbox';
import { euiMarkdownLinkValidator, DEFAULT_OPTIONS as LINK_VALIDATOR_DEFAULTS } from '../markdown_link_validator';
var DEFAULT_PARSING_PLUGINS = {
  emoji: [emoji, {
    emoticon: false
  }],
  lineBreaks: [breaks, {}],
  linkValidator: [euiMarkdownLinkValidator, LINK_VALIDATOR_DEFAULTS],
  checkbox: [MarkdownCheckbox.parser, {}],
  tooltip: [MarkdownTooltip.parser, {}]
};
export var getDefaultEuiMarkdownParsingPlugins = function getDefaultEuiMarkdownParsingPlugins() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var exclude = _ref.exclude,
    parsingConfig = _objectWithoutProperties(_ref, _excluded);
  var parsingPlugins = [[markdown, {}], [highlight, {}]];
  Object.entries(DEFAULT_PARSING_PLUGINS).forEach(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      pluginName = _ref3[0],
      plugin = _ref3[1];
    // Check for plugin exclusions
    if (!(exclude !== null && exclude !== void 0 && exclude.includes(pluginName))) {
      // Check for plugin configuration overrides
      if (pluginName in parsingConfig) {
        parsingPlugins.push([plugin[0], parsingConfig[pluginName]]);
      } else {
        parsingPlugins.push(plugin);
      }
    }
  });
  return parsingPlugins;
};
export var defaultParsingPlugins = getDefaultEuiMarkdownParsingPlugins();