import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as MarkdownTooltip from '../markdown_tooltip';
var DEFAULT_UI_PLUGINS = {
  tooltip: MarkdownTooltip.plugin
};
export var getDefaultEuiMarkdownUiPlugins = function getDefaultEuiMarkdownUiPlugins() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    exclude = _ref.exclude;
  var uiPlugins = [];
  Object.entries(DEFAULT_UI_PLUGINS).forEach(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      pluginName = _ref3[0],
      plugin = _ref3[1];
    if (!(exclude !== null && exclude !== void 0 && exclude.includes(pluginName))) {
      uiPlugins.push(plugin);
    }
  });
  return uiPlugins;
};
export var defaultUiPlugins = getDefaultEuiMarkdownUiPlugins();