import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiModal, EuiModalHeader, EuiModalHeaderTitle, EuiModalBody, EuiModalFooter } from './index';
import { EuiButton } from '../button';
import { jsx as ___EmotionJSX } from "@emotion/react";
var Modal = function Modal() {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isModalVisible = _useState2[0],
    setIsModalVisible = _useState2[1];
  var closeModal = function closeModal() {
    return setIsModalVisible(false);
  };
  var showModal = function showModal() {
    return setIsModalVisible(true);
  };
  var modalProps = {
    title: 'Do this thing',
    onClose: closeModal,
    children: React
  };
  return ___EmotionJSX("div", null, ___EmotionJSX(EuiButton, {
    onClick: showModal
  }, "Show confirm modal"), isModalVisible && ___EmotionJSX(EuiModal, modalProps, ___EmotionJSX(EuiModalHeader, null, ___EmotionJSX(EuiModalHeaderTitle, null, "Title of modal")), ___EmotionJSX(EuiModalBody, null, ___EmotionJSX("p", null, "This is a simple modal body")), ___EmotionJSX(EuiModalFooter, null, ___EmotionJSX(EuiButton, {
    onClick: closeModal,
    fill: true
  }, "Close"))));
};
beforeEach(function () {
  cy.mount(___EmotionJSX(Modal, null));
  cy.get('div.euiModal').should('not.exist');
  cy.get('button.euiButton').realClick();
  cy.get('div.euiModal').should('exist');
});
describe('EuiModal', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations when modal is open', function () {
      cy.checkAxe();
    });
    it('has zero violations when modal is closed', function () {
      cy.get('div.euiModalFooter button.euiButton').click();
      cy.get('div.euiModal').should('not.exist');
      cy.checkAxe();
    });
  });
});