import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "children", "initialFocus", "onClose", "maxWidth", "role", "style"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classnames from 'classnames';
import { keys, useEuiTheme } from '../../services';
import { isDOMNode } from '../../utils';
import { EuiButtonIcon } from '../button';
import { EuiFocusTrap } from '../focus_trap';
import { EuiOverlayMask } from '../overlay_mask';
import { EuiI18n } from '../i18n';
import { euiModalStyles } from './modal.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiModal = function EuiModal(_ref) {
  var className = _ref.className,
    children = _ref.children,
    initialFocus = _ref.initialFocus,
    onClose = _ref.onClose,
    _ref$maxWidth = _ref.maxWidth,
    maxWidth = _ref$maxWidth === void 0 ? true : _ref$maxWidth,
    _ref$role = _ref.role,
    role = _ref$role === void 0 ? 'dialog' : _ref$role,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  var onKeyDown = function onKeyDown(event) {
    if (event.key === keys.ESCAPE) {
      if (isDOMNode(event.target) && event.currentTarget.contains(event.target)) {
        event.preventDefault();
        event.stopPropagation();
        onClose(event);
      }
    }
  };
  var newStyle = style;
  if (typeof maxWidth !== 'boolean') {
    newStyle = _objectSpread(_objectSpread({}, newStyle), {}, {
      maxInlineSize: maxWidth
    });
  }
  var classes = classnames('euiModal', className);
  var euiTheme = useEuiTheme();
  var styles = euiModalStyles(euiTheme);
  var cssStyles = [styles.euiModal, maxWidth === true && styles.defaultMaxWidth];
  var cssCloseIconStyles = [styles.euiModal__closeIcon];
  return ___EmotionJSX(EuiOverlayMask, null, ___EmotionJSX(EuiFocusTrap, {
    initialFocus: initialFocus,
    scrollLock: true,
    preventScrollOnFocus: true
  }, ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes,
    onKeyDown: onKeyDown,
    tabIndex: 0,
    style: newStyle,
    role: role,
    "aria-modal": true
  }, rest), ___EmotionJSX(EuiI18n, {
    token: "euiModal.closeModal",
    default: "Closes this modal window"
  }, function (closeModal) {
    return ___EmotionJSX(EuiButtonIcon, {
      iconType: "cross",
      onClick: onClose,
      css: cssCloseIconStyles,
      className: "euiModal__closeIcon",
      color: "text",
      "aria-label": closeModal
    });
  }), children)));
};