import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classnames from 'classnames';
import { useEuiTheme } from '../../services';
import { euiModalBodyStyles } from './modal_body.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiModalBody = function EuiModalBody(_ref) {
  var className = _ref.className,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classnames('euiModalBody', className);
  var euiTheme = useEuiTheme();
  var styles = euiModalBodyStyles(euiTheme);
  var cssStyles = [styles.euiModalBody];
  var cssOverflowStyles = [styles.euiModalBody__overflow];
  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), ___EmotionJSX("div", {
    css: cssOverflowStyles,
    className: "euiModalBody__overflow"
  }, children));
};