import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _createClass from "@babel/runtime/helpers/createClass";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { useCallback, useEffect, useRef, useState } from 'react';
import { EuiObserver } from '../observer';
export var hasResizeObserver = typeof window !== 'undefined' && typeof window.ResizeObserver !== 'undefined';
export var EuiResizeObserver = /*#__PURE__*/function (_EuiObserver) {
  function EuiResizeObserver() {
    var _this;
    _classCallCheck(this, EuiResizeObserver);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiResizeObserver, [].concat(args));
    _defineProperty(_this, "name", 'EuiResizeObserver');
    _defineProperty(_this, "state", {
      height: 0,
      width: 0
    });
    _defineProperty(_this, "onResize", function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        entry = _ref2[0];
      var _entry$borderBoxSize$ = entry.borderBoxSize[0],
        width = _entry$borderBoxSize$.inlineSize,
        height = _entry$borderBoxSize$.blockSize;

      // Check for actual resize event
      if (_this.state.height === height && _this.state.width === width) {
        return;
      }
      _this.props.onResize({
        height: height,
        width: width
      });
      _this.setState({
        height: height,
        width: width
      });
    });
    _defineProperty(_this, "beginObserve", function () {
      // The superclass checks that childNode is not null before invoking
      // beginObserve()
      var childNode = _this.childNode;
      _this.observer = makeResizeObserver(childNode, _this.onResize);
    });
    return _this;
  }
  _inherits(EuiResizeObserver, _EuiObserver);
  return _createClass(EuiResizeObserver);
}(EuiObserver);
var makeResizeObserver = function makeResizeObserver(node, callback) {
  var observer;
  if (hasResizeObserver) {
    observer = new window.ResizeObserver(callback);
    observer.observe(node);
  }
  return observer;
};
export var useResizeObserver = function useResizeObserver(container, dimension) {
  var _useState = useState({
      width: 0,
      height: 0
    }),
    _useState2 = _slicedToArray(_useState, 2),
    size = _useState2[0],
    _setSize = _useState2[1];

  // _currentDimensions and _setSize are used to only store the
  // new state (and trigger a re-render) when the new dimensions actually differ
  var _currentDimensions = useRef(size);
  var setSize = useCallback(function (dimensions) {
    var doesWidthMatter = dimension !== 'height';
    var doesHeightMatter = dimension !== 'width';
    if (doesWidthMatter && _currentDimensions.current.width !== dimensions.width || doesHeightMatter && _currentDimensions.current.height !== dimensions.height) {
      _currentDimensions.current = dimensions;
      _setSize(dimensions);
    }
  }, [dimension]);
  useEffect(function () {
    if (container != null) {
      var observer = makeResizeObserver(container, function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 1),
          entry = _ref4[0];
        var _entry$borderBoxSize$2 = entry.borderBoxSize[0],
          inlineSize = _entry$borderBoxSize$2.inlineSize,
          blockSize = _entry$borderBoxSize$2.blockSize;
        setSize({
          width: inlineSize,
          height: blockSize
        });
      });
      return function () {
        return observer && observer.disconnect();
      };
    } else {
      setSize({
        width: 0,
        height: 0
      });
    }
  }, [container, setSize]);
  return size;
};