import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { Children, cloneElement, Component } from 'react';
import { htmlIdGenerator } from '../../services/accessibility';
export var EuiOutsideClickDetector = /*#__PURE__*/function (_Component) {
  function EuiOutsideClickDetector(props) {
    var _this;
    _classCallCheck(this, EuiOutsideClickDetector);
    _this = _callSuper(this, EuiOutsideClickDetector, [props]);

    // the id is used to identify which EuiOutsideClickDetector
    // is the source of a click event; as the click event bubbles
    // up and reaches the click detector's child component the
    // id value is stamped on the event. This id is inspected
    // in the document's click handler, and if the id doesn't
    // exist or doesn't match this detector's id, then trigger
    // the outsideClick callback.
    //
    // Taking this approach instead of checking if the event's
    // target element exists in this component's DOM sub-tree is
    // necessary for handling clicks originating from children
    // rendered through React's portals (EuiPortal). The id tracking
    // works because React guarantees the event bubbles through the
    // virtual DOM and executes EuiClickDetector's onClick handler,
    // stamping the id even though the event originates outside
    // this component's reified DOM tree.
    // We are working with the assumption that a click event is
    // equivalent to a sequential, compound press and release of
    // the pointing device (mouse, finger, stylus, etc.).
    // A click event's target can be imprecise, as the value will be
    // the closest common ancestor of the press (mousedown, touchstart)
    // and release (mouseup, touchend) events (often <body />) if
    // the the target of each event differs.
    // We need the actual event targets to make the correct decisions
    // about user intention. So, consider the down/start and up/end
    // items below as the deconstruction of a click event.
    _defineProperty(_this, "id", void 0);
    _defineProperty(_this, "capturedDownIds", void 0);
    _defineProperty(_this, "onClickOutside", function (e) {
      var _this$props = _this.props,
        isDisabled = _this$props.isDisabled,
        onOutsideClick = _this$props.onOutsideClick;
      if (isDisabled) {
        _this.capturedDownIds = [];
        return;
      }
      var event = e;
      if (event.euiGeneratedBy && event.euiGeneratedBy.includes(_this.id) || _this.capturedDownIds.includes(_this.id)) {
        _this.capturedDownIds = [];
        return;
      }
      _this.capturedDownIds = [];
      return onOutsideClick(event);
    });
    _defineProperty(_this, "onChildClick", function (event, cb) {
      // to support nested click detectors, build an array
      // of detector ids that have been encountered;
      if (event.nativeEvent.hasOwnProperty('euiGeneratedBy')) {
        event.nativeEvent.euiGeneratedBy.push(_this.id);
      } else {
        event.nativeEvent.euiGeneratedBy = [_this.id];
      }
      if (cb) cb(event);
    });
    _defineProperty(_this, "onChildMouseDown", function (event) {
      _this.onChildClick(event, function (e) {
        var nativeEvent = e.nativeEvent;
        _this.capturedDownIds = nativeEvent.euiGeneratedBy;
        if (_this.props.onMouseDown) _this.props.onMouseDown(e);
        if (_this.props.onTouchStart) _this.props.onTouchStart(e);
      });
    });
    _defineProperty(_this, "onChildMouseUp", function (event) {
      _this.onChildClick(event, function (e) {
        if (_this.props.onMouseUp) _this.props.onMouseUp(e);
        if (_this.props.onTouchEnd) _this.props.onTouchEnd(e);
      });
    });
    _this.id = htmlIdGenerator()();
    _this.capturedDownIds = [];
    return _this;
  }
  _inherits(EuiOutsideClickDetector, _Component);
  return _createClass(EuiOutsideClickDetector, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      document.addEventListener('mouseup', this.onClickOutside);
      document.addEventListener('touchend', this.onClickOutside);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.removeEventListener('mouseup', this.onClickOutside);
      document.removeEventListener('touchend', this.onClickOutside);
    }
  }, {
    key: "render",
    value: function render() {
      var props = _objectSpread(_objectSpread({}, this.props.children.props), {
        onMouseDown: this.onChildMouseDown,
        onTouchStart: this.onChildMouseDown,
        onMouseUp: this.onChildMouseUp,
        onTouchEnd: this.onChildMouseUp
      });
      var child = Children.only(this.props.children);
      return /*#__PURE__*/cloneElement(child, props);
    }
  }]);
}(Component);