import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "children", "headerZindexLocation", "maskRef"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useEffect, useState } from 'react';
import { cx } from '@emotion/css';
import { Global } from '@emotion/react';
import { keysOf } from '../common';
import { useCombinedRefs, useEuiMemoizedStyles } from '../../services';
import { EuiPortal } from '../portal';
import { euiOverlayMaskStyles } from './overlay_mask.styles';
import { euiOverlayMaskBodyStyles } from './overlay_mask_body.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiOverlayMask = function EuiOverlayMask(_ref) {
  var className = _ref.className,
    children = _ref.children,
    _ref$headerZindexLoca = _ref.headerZindexLocation,
    headerZindexLocation = _ref$headerZindexLoca === void 0 ? 'above' : _ref$headerZindexLoca,
    maskRef = _ref.maskRef,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    overlayMaskNode = _useState2[0],
    setOverlayMaskNode = _useState2[1];
  var combinedMaskRef = useCombinedRefs([setOverlayMaskNode, maskRef]);
  var styles = useEuiMemoizedStyles(euiOverlayMaskStyles);
  var cssStyles = cx([styles.euiOverlayMask, styles["".concat(headerZindexLocation, "Header")]]);
  useEffect(function () {
    if (!overlayMaskNode) return;
    keysOf(rest).forEach(function (key) {
      if (typeof rest[key] !== 'string') {
        throw new Error("Unhandled property type. EuiOverlayMask property ".concat(key, " is not a string."));
      }
      if (overlayMaskNode) {
        overlayMaskNode.setAttribute(key, rest[key]);
      }
    });
  }, [overlayMaskNode]); // eslint-disable-line react-hooks/exhaustive-deps

  // Note: Use `classList.add/remove` instead of setting the entire `className`
  // so as not to override any existing classes set by `EuiPortal`
  useEffect(function () {
    if (overlayMaskNode) {
      overlayMaskNode.classList.add('euiOverlayMask', cssStyles);
      overlayMaskNode.dataset.relativeToHeader = headerZindexLocation;
      return function () {
        return overlayMaskNode.classList.remove(cssStyles);
      };
    }
  }, [overlayMaskNode, cssStyles, headerZindexLocation]);
  useEffect(function () {
    if (className && overlayMaskNode) {
      var _overlayMaskNode$clas;
      var classNameArgs = className.split(' '); // The `classList` API doesn't support multiple classes in the same string
      (_overlayMaskNode$clas = overlayMaskNode.classList).add.apply(_overlayMaskNode$clas, _toConsumableArray(classNameArgs));
      return function () {
        var _overlayMaskNode$clas2;
        return (_overlayMaskNode$clas2 = overlayMaskNode.classList).remove.apply(_overlayMaskNode$clas2, _toConsumableArray(classNameArgs));
      };
    }
  }, [overlayMaskNode, className]);
  return ___EmotionJSX(EuiPortal, {
    portalRef: combinedMaskRef
  }, ___EmotionJSX(Global, {
    styles: euiOverlayMaskBodyStyles
  }), children);
};