import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "restrictWidth", "className", "paddingSize", "grow", "direction"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { setStyleForRestrictedPageWidth } from './_restrict_width';
import { useEuiPaddingCSS } from '../../global_styling';
import { euiPageStyles } from './page.styles';
import { useEuiTheme } from '../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiPage = function EuiPage(_ref) {
  var children = _ref.children,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    className = _ref.className,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'row' : _ref$direction,
    rest = _objectWithoutProperties(_ref, _excluded);
  // Set max-width as a style prop
  var widthStyles = setStyleForRestrictedPageWidth(restrictWidth, rest === null || rest === void 0 ? void 0 : rest.style);
  var euiTheme = useEuiTheme();
  var styles = euiPageStyles(euiTheme);
  var padding = useEuiPaddingCSS()[paddingSize];
  var stylesCSS = [styles.euiPage, styles[direction], grow && styles.grow, padding, restrictWidth && styles.restrictWidth];
  var classes = classNames('euiPage', className);
  return ___EmotionJSX("div", _extends({
    css: stylesCSS,
    className: classes
  }, rest, {
    style: widthStyles
  }), children);
};