import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "restrictWidth", "className", "css", "component", "panelled", "panelProps", "paddingSize", "borderRadius"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { setStyleForRestrictedPageWidth } from '../_restrict_width';
import { EuiPanel } from '../../panel';
import { useEuiPaddingCSS } from '../../../global_styling';
import { euiPageBodyStyles } from './page_body.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiPageBody = function EuiPageBody(_ref) {
  var children = _ref.children,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    className = _ref.className,
    css = _ref.css,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    panelled = _ref.panelled,
    panelProps = _ref.panelProps,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$borderRadius = _ref.borderRadius,
    borderRadius = _ref$borderRadius === void 0 ? 'none' : _ref$borderRadius,
    rest = _objectWithoutProperties(_ref, _excluded);
  // Set max-width as a style prop
  var widthStyles = setStyleForRestrictedPageWidth(restrictWidth, rest === null || rest === void 0 ? void 0 : rest.style);

  // Shared
  var classes = classNames('euiPageBody', className);
  var styles = euiPageBodyStyles();
  var cssStyles = [styles.euiPageBody, restrictWidth && styles.restrictWidth];

  // Panelled
  var panelClasses = classNames(classes, panelProps === null || panelProps === void 0 ? void 0 : panelProps.className);
  var panelCssStyles = [].concat(cssStyles, [panelProps === null || panelProps === void 0 ? void 0 : panelProps.css, css]);

  // Non-panelled
  var padding = useEuiPaddingCSS()[paddingSize];
  var componentCssStyles = [].concat(cssStyles, [padding, css]);
  return panelled ? ___EmotionJSX(EuiPanel, _extends({
    borderRadius: borderRadius,
    paddingSize: paddingSize
  }, panelProps, rest, {
    className: panelClasses,
    css: panelCssStyles
  }), children) : ___EmotionJSX(Component, _extends({}, rest, {
    className: classes,
    css: componentCssStyles,
    style: widthStyles
  }), children);
};