import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "restrictWidth", "paddingSize", "bottomBorder", "alignItems", "responsive", "children", "pageTitle", "pageTitleProps", "iconType", "iconProps", "tabs", "tabsProps", "breadcrumbs", "breadcrumbProps", "description", "rightSideItems", "rightSideGroupProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { useEuiPaddingCSS } from '../../../global_styling';
import { EuiPageHeaderContent } from './page_header_content';
import { euiPageHeaderStyles } from './page_header.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiPageHeader = function EuiPageHeader(_ref) {
  var className = _ref.className,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    bottomBorder = _ref.bottomBorder,
    alignItems = _ref.alignItems,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? true : _ref$responsive,
    children = _ref.children,
    pageTitle = _ref.pageTitle,
    pageTitleProps = _ref.pageTitleProps,
    iconType = _ref.iconType,
    iconProps = _ref.iconProps,
    tabs = _ref.tabs,
    tabsProps = _ref.tabsProps,
    breadcrumbs = _ref.breadcrumbs,
    breadcrumbProps = _ref.breadcrumbProps,
    description = _ref.description,
    rightSideItems = _ref.rightSideItems,
    rightSideGroupProps = _ref.rightSideGroupProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var useTheme = useEuiTheme();
  var styles = euiPageHeaderStyles(useTheme);
  var inlinePadding = useEuiPaddingCSS('horizontal');
  var cssStyles = [styles.euiPageHeader, inlinePadding[paddingSize], bottomBorder === 'extended' && styles.border];
  var classes = classNames('euiPageHeader', className);
  var contentProps = {
    restrictWidth: restrictWidth,
    paddingSize: paddingSize,
    // Set the bottom to false to ensure the forced one doesn't render
    // when we'll be rendering it at this parent
    bottomBorder: bottomBorder === 'extended' ? false : bottomBorder,
    alignItems: alignItems,
    responsive: responsive,
    pageTitle: pageTitle,
    pageTitleProps: pageTitleProps,
    iconType: iconType,
    iconProps: iconProps,
    tabs: tabs,
    tabsProps: tabsProps,
    description: description,
    rightSideItems: rightSideItems,
    rightSideGroupProps: rightSideGroupProps,
    breadcrumbs: breadcrumbs,
    breadcrumbProps: breadcrumbProps
  };
  return ___EmotionJSX("header", _extends({
    className: classes,
    css: cssStyles
  }, rest), ___EmotionJSX(EuiPageHeaderContent, contentProps, children));
};