import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "pageTitle", "pageTitleProps", "iconType", "iconProps", "tabs", "tabsProps", "description", "breadcrumbs", "breadcrumbProps", "alignItems", "responsive", "rightSideItems", "rightSideGroupProps", "children", "restrictWidth", "paddingSize", "bottomBorder", "style"],
  _excluded2 = ["label"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { EuiIcon } from '../../icon';
import { EuiTab, EuiTabs } from '../../tabs';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiSpacer } from '../../spacer';
import { EuiTitle } from '../../title';
import { EuiText } from '../../text';
import { useIsWithinBreakpoints, useEuiMemoizedStyles } from '../../../services';
import { EuiScreenReaderOnly } from '../../accessibility';
import { EuiBreadcrumbs } from '../../breadcrumbs';
import { useEuiPaddingCSS } from '../../../global_styling';
import { setStyleForRestrictedPageWidth } from '../_restrict_width';
import { euiPageHeaderStyles } from './page_header.styles';
import { euiPageHeaderContentStyles } from './page_header_content.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var ALIGN_ITEMS = ['top', 'bottom', 'center', 'stretch'];

// Gets all the tab props including the button or link props

/**
 * The left side can either be a title with optional description and/or icon;
 * Or a list of tabs,
 * Or a custom node
 */

export var EuiPageHeaderContent = function EuiPageHeaderContent(_ref) {
  var className = _ref.className,
    pageTitle = _ref.pageTitle,
    pageTitleProps = _ref.pageTitleProps,
    iconType = _ref.iconType,
    iconProps = _ref.iconProps,
    tabs = _ref.tabs,
    tabsProps = _ref.tabsProps,
    description = _ref.description,
    breadcrumbs = _ref.breadcrumbs,
    breadcrumbProps = _ref.breadcrumbProps,
    alignItems = _ref.alignItems,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? true : _ref$responsive,
    rightSideItems = _ref.rightSideItems,
    rightSideGroupProps = _ref.rightSideGroupProps,
    children = _ref.children,
    restrictWidth = _ref.restrictWidth,
    _ref$paddingSize = _ref.paddingSize,
    _paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _bottom_border = _ref.bottomBorder,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsiveBreakpoint = useIsWithinBreakpoints(['xs', 's'], !!responsive);
  var classes = classNames('euiPageHeaderContent', className);
  var pageHeaderStyles = useEuiMemoizedStyles(euiPageHeaderStyles);
  var contentStyles = useEuiMemoizedStyles(euiPageHeaderContentStyles);
  var styles = setStyleForRestrictedPageWidth(restrictWidth, style);
  var paddingSides = 'vertical';
  var paddingSize = _paddingSize;
  var bottomBorder = _bottom_border;
  var onlyChildren = !tabs && !pageTitle && !rightSideItems && !description && children;
  var onlyTabs = tabs && !pageTitle && !rightSideItems && !description && !children;
  var tabsAsTitle = tabs && !pageTitle;
  var tabsAtTheBottom = pageTitle && tabs;
  var borderWithoutPadding = (!paddingSize || paddingSize === 'none') && bottomBorder;
  if (onlyTabs) {
    paddingSize = 'none';
  } else if (tabsAsTitle) {
    paddingSides = 'bottom';
  } else if (tabsAtTheBottom) {
    paddingSides = 'top';
    bottomBorder = bottomBorder === false ? false : true;
  } else if (borderWithoutPadding) {
    paddingSides = 'bottom';
    paddingSize = 'l';
  }
  var blockPadding = useEuiPaddingCSS(paddingSides);
  var cssStyles = [contentStyles.euiPageHeaderContent, bottomBorder && pageHeaderStyles.border, blockPadding[paddingSize]];
  var childrenOnlyStyles = [contentStyles.childrenOnly.flex, contentStyles[alignItems || 'center'], isResponsiveBreakpoint && responsive && (responsive === 'reverse' ? contentStyles.childrenOnly.responsiveReverse : contentStyles.childrenOnly.responsive)];

  // Don't go any further if there's no other content than children
  if (onlyChildren) {
    return ___EmotionJSX("div", _extends({
      css: cssStyles
    }, rest), ___EmotionJSX("div", {
      css: childrenOnlyStyles
    }, children));
  }
  var descriptionNode;
  if (description) {
    descriptionNode = ___EmotionJSX(React.Fragment, null, (pageTitle || tabs) && ___EmotionJSX(EuiSpacer, null), ___EmotionJSX(EuiText, {
      grow: false
    }, ___EmotionJSX("p", null, description)));
  }
  var optionalBreadcrumbs = breadcrumbs ? ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiBreadcrumbs, _extends({
    breadcrumbs: breadcrumbs
  }, breadcrumbProps)), ___EmotionJSX(EuiSpacer, {
    size: "s"
  })) : undefined;
  var pageTitleNode;
  if (pageTitle) {
    var iconCssStyles = [contentStyles.euiPageHeaderContent__titleIcon, iconProps === null || iconProps === void 0 ? void 0 : iconProps.css];
    var icon = iconType ? ___EmotionJSX(EuiIcon, _extends({
      size: "xl"
    }, iconProps, {
      css: iconCssStyles,
      type: iconType
    })) : undefined;
    pageTitleNode = ___EmotionJSX(EuiTitle, _extends({}, pageTitleProps, {
      size: "l"
    }), ___EmotionJSX("h1", null, icon, pageTitle));
  }
  var tabsNode;
  if (tabs) {
    var _tabs$find;
    var tabsSize = pageTitle ? 'l' : 'xl';
    var renderTabs = function renderTabs() {
      return tabs.map(function (tab, index) {
        var label = tab.label,
          tabRest = _objectWithoutProperties(tab, _excluded2);
        return ___EmotionJSX(EuiTab, _extends({
          key: index
        }, tabRest), label);
      });
    };

    // When tabs exist without a pageTitle, we need to recreate an h1 based on the currently selected tab and visually hide it
    var screenReaderPageTitle = !pageTitle && ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("h1", null, (_tabs$find = tabs.find(function (obj) {
      return obj.isSelected === true;
    })) === null || _tabs$find === void 0 ? void 0 : _tabs$find.label));
    tabsNode = ___EmotionJSX(React.Fragment, null, pageTitleNode && ___EmotionJSX(EuiSpacer, null), screenReaderPageTitle, ___EmotionJSX(EuiTabs, _extends({}, tabsProps, {
      bottomBorder: false,
      size: tabsSize
    }), renderTabs()));
  }
  var childrenNode = children && ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiSpacer, null), children);
  var bottomContentNode;
  if (tabsNode && pageTitleNode) {
    bottomContentNode = ___EmotionJSX("div", {
      className: "euiPageHeaderContent__bottom"
    }, pageTitleNode && tabsNode);
  }

  /**
   * The left side order depends on if a `pageTitle` was supplied.
   * If not, but there are `tabs`, then the tabs become the page title
   */
  var leftSideOrder;
  if (tabsNode && !pageTitleNode) {
    leftSideOrder = ___EmotionJSX(React.Fragment, null, tabsNode, descriptionNode, childrenNode);
  } else {
    leftSideOrder = ___EmotionJSX(React.Fragment, null, pageTitleNode, descriptionNode, childrenNode);
  }
  var leftSideFlexItem = ___EmotionJSX(EuiFlexItem, {
    grow: 2,
    css: contentStyles.euiPageHeaderContent__leftSideItems
  }, leftSideOrder);
  var rightSideFlexItem;
  if (rightSideItems && rightSideItems.length) {
    var itemsToRender = isResponsiveBreakpoint ? rightSideItems : _toConsumableArray(rightSideItems).reverse();
    var rightSideFlexItems = itemsToRender.map(function (item, index) {
      return ___EmotionJSX(EuiFlexItem, {
        key: index,
        grow: false,
        css: contentStyles.euiPageHeaderContent__rightSideItem
      }, item);
    });
    var _cssStyles = [contentStyles.euiPageHeaderContent__rightSideItems, rightSideGroupProps === null || rightSideGroupProps === void 0 ? void 0 : rightSideGroupProps.css];
    rightSideFlexItem = ___EmotionJSX(EuiFlexGroup, _extends({
      gutterSize: "l",
      responsive: false,
      wrap: true
    }, rightSideGroupProps, {
      css: _cssStyles
    }), rightSideFlexItems);
  }
  return ___EmotionJSX("div", _extends({
    className: classes,
    css: cssStyles,
    style: styles
  }, rest), optionalBreadcrumbs, ___EmotionJSX(EuiFlexGroup, {
    responsive: !!responsive,
    css: contentStyles.euiPageHeaderContent__top,
    className: "euiPageHeaderContent__top",
    alignItems: alignItems === 'bottom' ? 'flexEnd' : alignItems === 'top' ? 'flexStart' : alignItems,
    gutterSize: "l",
    wrap: true
  }, isResponsiveBreakpoint && responsive === 'reverse' ? ___EmotionJSX(React.Fragment, null, rightSideFlexItem, leftSideFlexItem) : ___EmotionJSX(React.Fragment, null, leftSideFlexItem, rightSideFlexItem)), bottomContentNode);
};