import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "alignment", "restrictWidth", "bottomBorder", "paddingSize", "color", "grow", "contentProps", "component"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { setStyleForRestrictedPageWidth } from '../_restrict_width';
import { useEuiTheme } from '../../../services';
import { euiPageSectionContentStyles, euiPageSectionStyles } from './page_section.styles';
import { useEuiPaddingCSS, useEuiBackgroundColorCSS } from '../../../global_styling';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiPageSection = function EuiPageSection(_ref) {
  var children = _ref.children,
    _ref$alignment = _ref.alignment,
    alignment = _ref$alignment === void 0 ? 'top' : _ref$alignment,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    bottomBorder = _ref.bottomBorder,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'transparent' : _ref$color,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? false : _ref$grow,
    contentProps = _ref.contentProps,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'section' : _ref$component,
    rest = _objectWithoutProperties(_ref, _excluded);
  // Set max-width as a style prop
  var widthStyles = setStyleForRestrictedPageWidth(restrictWidth, contentProps === null || contentProps === void 0 ? void 0 : contentProps.style);
  var useTheme = useEuiTheme();
  var styles = euiPageSectionStyles(useTheme);
  var inlinePadding = useEuiPaddingCSS('horizontal');
  var blockPadding = useEuiPaddingCSS('vertical');
  var colors = useEuiBackgroundColorCSS();
  var cssStyles = [styles.euiPageSection, grow && styles.grow, inlinePadding[paddingSize], bottomBorder === 'extended' && styles.border, alignment && styles[alignment], colors[color]];
  var contentStyles = euiPageSectionContentStyles();
  var cssContentStyles = [contentStyles.euiPageSection__content, blockPadding[paddingSize], bottomBorder === true && styles.border, alignment.toLowerCase().includes('center') && contentStyles.center, restrictWidth && contentStyles.restrictWidth, contentProps === null || contentProps === void 0 ? void 0 : contentProps.css];
  return ___EmotionJSX(Component, _extends({
    css: cssStyles
  }, rest), ___EmotionJSX("div", _extends({}, contentProps, {
    css: cssContentStyles,
    style: widthStyles
  }), children));
};