import _extends from "@babel/runtime/helpers/extends";
import _typeof from "@babel/runtime/helpers/typeof";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "sticky", "paddingSize", "minWidth", "responsive", "hasEmbellish", "style"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useLayoutEffect, useState } from 'react';
import { logicalStyle, useEuiPaddingCSS } from '../../../global_styling';
import { useEuiTheme, useIsWithinBreakpoints } from '../../../services';
import { euiPageSidebarStyles } from './page_sidebar.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiPageSidebar = function EuiPageSidebar(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$sticky = _ref.sticky,
    sticky = _ref$sticky === void 0 ? false : _ref$sticky,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$minWidth = _ref.minWidth,
    minWidth = _ref$minWidth === void 0 ? 248 : _ref$minWidth,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
    _ref$hasEmbellish = _ref.hasEmbellish,
    hasEmbellish = _ref$hasEmbellish === void 0 ? false : _ref$hasEmbellish,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  var themeContext = useEuiTheme();
  var styles = euiPageSidebarStyles(themeContext);
  var isResponding = useIsWithinBreakpoints(responsive);
  var cssStyles = [styles.euiPageSidebar, !isResponding && sticky && styles.sticky, hasEmbellish && styles.embellish, useEuiPaddingCSS()[paddingSize]];

  // Inline styles for setting up width and sticky offsets
  var _useState = useState(_objectSpread(_objectSpread({}, style), logicalStyle('min-width', isResponding ? '100%' : minWidth))),
    _useState2 = _slicedToArray(_useState, 2),
    inlineStyles = _useState2[0],
    setInlineStyles = _useState2[1];
  useLayoutEffect(function () {
    var updatedStyles = _objectSpread(_objectSpread({}, style), logicalStyle('min-width', isResponding ? '100%' : minWidth));
    if (sticky) {
      var offset = _typeof(sticky) === 'object' ? "".concat(sticky === null || sticky === void 0 ? void 0 : sticky.offset, "px") : 'var(--euiFixedHeadersOffset, 0)';
      updatedStyles = _objectSpread(_objectSpread(_objectSpread({}, updatedStyles), logicalStyle('top', offset)), logicalStyle('max-height', "calc(100vh - ".concat(offset, ")")));
    }
    setInlineStyles(updatedStyles);
  }, [style, sticky, themeContext.euiTheme.base, isResponding, minWidth]);
  return ___EmotionJSX("div", _extends({
    className: className,
    css: cssStyles,
    style: inlineStyles
  }, rest), children);
};