import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "paddingSize", "restrictWidth", "parent"];
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import React, { useEffect, useRef, useState } from 'react';
import { createPortal } from 'react-dom';
import { findElementBySelectorOrRef } from '../../../services';
import { EuiBottomBar } from '../../bottom_bar';
import { EuiPageSection } from '../../page/page_section';
import { jsx as ___EmotionJSX } from "@emotion/react";
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1y6dyt1-bar",
  styles: "overflow:hidden;flex-shrink:0;label:bar;"
} : {
  name: "1y6dyt1-bar",
  styles: "overflow:hidden;flex-shrink:0;label:bar;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var _EuiPageBottomBar = function _EuiPageBottomBar(_ref2) {
  var children = _ref2.children,
    paddingSize = _ref2.paddingSize,
    restrictWidth = _ref2.restrictWidth,
    parent = _ref2.parent,
    rest = _objectWithoutProperties(_ref2, _excluded);
  // In order for the bottom bar to be placed at the end of the content,
  // it must know what parent element to insert into
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    hasValidAnchor = _useState2[0],
    setHasValidAnchor = _useState2[1];
  var animationFrameId = useRef();
  var parentNode = useRef(null);
  useEffect(function () {
    animationFrameId.current = window.requestAnimationFrame(function () {
      parentNode.current = findElementBySelectorOrRef(parent);
      setHasValidAnchor(parentNode.current ? true : false);
    });
    return function () {
      animationFrameId.current && window.cancelAnimationFrame(animationFrameId.current);
    };
  }, [parent]);
  var bar = ___EmotionJSX(EuiBottomBar, _extends({
    paddingSize: 'none',
    position: "sticky"
    // Hide the overflow in case of larger flex margins than padding
    ,
    css: _ref
    // Using object here because of the possible conflict with overriding props and position `sticky`
  }, rest), ___EmotionJSX(EuiPageSection, {
    paddingSize: paddingSize,
    restrictWidth: restrictWidth
  }, children));
  return hasValidAnchor && parentNode.current ? /*#__PURE__*/createPortal(bar, parentNode.current) : bar;
};