import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "alignment", "restrictWidth", "paddingSize", "grow", "panelled", "color"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { EuiEmptyPrompt } from '../../empty_prompt';
import { EuiPageSection } from '../../page/page_section';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var _EuiPageEmptyPrompt = function _EuiPageEmptyPrompt(_ref) {
  var children = _ref.children,
    _ref$alignment = _ref.alignment,
    alignment = _ref$alignment === void 0 ? 'center' : _ref$alignment,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    panelled = _ref.panelled,
    color = _ref.color,
    rest = _objectWithoutProperties(_ref, _excluded);
  /**
   * If panelled = true, then either the section or empty prompt must be plain;
   * If color is anything but plain, then it must be the section that is plain;
   * If panelled = true, but color is undefined, then default to the empty prompt being plain;
   */

  var sectionColor;
  var emptyPromptColor;
  if (panelled && color === undefined) {
    sectionColor = 'plain';
    emptyPromptColor = 'subdued';
  } else if (panelled && color !== 'plain') {
    sectionColor = 'plain';
    emptyPromptColor = color;
  } else {
    sectionColor = 'transparent';
    emptyPromptColor = color || 'plain';
  }
  return ___EmotionJSX(EuiPageSection, {
    paddingSize: paddingSize,
    color: sectionColor,
    grow: grow,
    restrictWidth: restrictWidth,
    alignment: alignment
  }, ___EmotionJSX(EuiEmptyPrompt
  // @ts-expect-error Hasn't been updated to use all the new values yet
  , _extends({
    paddingSize: paddingSize,
    color: emptyPromptColor,
    body: children
  }, rest)));
};