import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "component", "panelled", "border", "paddingSize", "responsive"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { useEuiPaddingCSS } from '../../../global_styling';
import { useEuiTheme, useIsWithinBreakpoints } from '../../../services';
import { euiPageInnerStyles } from './page_inner.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var _EuiPageInner = function _EuiPageInner(_ref) {
  var children = _ref.children,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'main' : _ref$component,
    panelled = _ref.panelled,
    border = _ref.border,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
    rest = _objectWithoutProperties(_ref, _excluded);
  var themeContext = useEuiTheme();
  var isResponding = useIsWithinBreakpoints(responsive);
  var styles = euiPageInnerStyles(themeContext);
  var paddingStyles = useEuiPaddingCSS()[paddingSize];
  var borderSide;
  if (border && isResponding) {
    borderSide = 'top';
  } else if (border) {
    borderSide = 'left';
  }
  var cssStyles = [styles.euiPageInner, paddingStyles, panelled && styles.panelled, borderSide && styles.border[borderSide]];
  return (
    // @ts-expect-error Generic element type mismatch
    ___EmotionJSX(Component, _extends({
      css: cssStyles
    }, rest), children)
  );
};