/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiShadow } from '../../../themes/amsterdam/global_styling/mixins';
import { euiBackgroundColor, logicalCSS } from '../../../global_styling';
export var euiPageInnerStyles = function euiPageInnerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiPageInner: /*#__PURE__*/css("display:flex;flex-direction:column;align-items:stretch;flex:1 1 100%;", logicalCSS('max-width', '100%'), " ", logicalCSS('min-width', '0'), ";;label:euiPageInner;"),
    panelled: /*#__PURE__*/css("background:", euiBackgroundColor(euiThemeContext, 'plain'), ";", euiShadow(euiThemeContext, 'm'), ";;label:panelled;"),
    border: {
      top: /*#__PURE__*/css(logicalCSS('border-top', euiTheme.border.thin), ";;label:top;"),
      left: /*#__PURE__*/css(logicalCSS('border-left', euiTheme.border.thin), ";;label:left;")
    }
  };
};