import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "grow", "direction", "responsive"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { useEuiTheme, useIsWithinBreakpoints } from '../../../services';
import { euiPageOuterStyles } from './page_outer.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var PAGE_DIRECTIONS = ['row', 'column'];
export var _EuiPageOuter = function _EuiPageOuter(_ref) {
  var children = _ref.children,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'row' : _ref$direction,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
    rest = _objectWithoutProperties(_ref, _excluded);
  var themeContext = useEuiTheme();
  var styles = euiPageOuterStyles(themeContext);
  var isResponding = useIsWithinBreakpoints(responsive);
  var cssStyles = [styles.euiPageOuter, styles[isResponding ? 'column' : direction], grow && styles.grow];
  return ___EmotionJSX("div", _extends({
    css: cssStyles
  }, rest), children);
};