import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "responsive", "restrictWidth", "paddingSize", "grow", "bottomBorder", "offset", "panelled", "contentBorder", "component", "mainProps", "className", "minHeight", "style"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { createContext, useContext, useMemo } from 'react';
import classNames from 'classnames';
import { _EuiPageOuter as EuiPageOuter } from './outer';
import { _EuiPageInner as EuiPageInner } from './inner';
import { _EuiPageBottomBar as EuiPageBottomBar } from './bottom_bar/page_bottom_bar';
import { _EuiPageEmptyPrompt as EuiPageEmptyPrompt } from './empty_prompt/page_empty_prompt';
import { EuiPageHeader, EuiPageSection, EuiPageSidebar } from '../page';
import { useGeneratedHtmlId } from '../../services';
import { logicalStyles } from '../../global_styling';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var TemplateContext = /*#__PURE__*/createContext({
  sidebar: {},
  section: {},
  header: {},
  emptyPrompt: {},
  bottomBar: {}
});
/**
 * Consumed via `EuiPageTemplate`,
 * it controls and propogates most of the shared props per direct child
 */
export var _EuiPageTemplate = function _EuiPageTemplate(_ref) {
  var children = _ref.children,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? true : _ref$restrictWidth,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    bottomBorder = _ref.bottomBorder,
    offset = _ref.offset,
    panelled = _ref.panelled,
    contentBorder = _ref.contentBorder,
    component = _ref.component,
    mainProps = _ref.mainProps,
    className = _ref.className,
    _ref$minHeight = _ref.minHeight,
    minHeight = _ref$minHeight === void 0 ? '460px' : _ref$minHeight,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  // Used as a target to insert the bottom bar component
  var pageInnerId = useGeneratedHtmlId({
    prefix: 'EuiPageTemplateInner',
    conditionalId: mainProps === null || mainProps === void 0 ? void 0 : mainProps.id
  });

  // Sections include page header
  var _useMemo = useMemo(function () {
      var sidebar = [];
      var sections = [];
      React.Children.toArray(children).forEach(function (child) {
        if (! /*#__PURE__*/React.isValidElement(child)) return; // Skip non-components

        if (child.type === _EuiPageSidebar || child.props.__EMOTION_TYPE_PLEASE_DO_NOT_USE__ === _EuiPageSidebar) {
          sidebar.push(child);
        } else {
          sections.push(child);
        }
      });
      return [sidebar, sections];
    }, [children]),
    _useMemo2 = _slicedToArray(_useMemo, 2),
    sidebar = _useMemo2[0],
    sections = _useMemo2[1];
  var classes = classNames('euiPageTemplate', className);
  var pageStyle = useMemo(function () {
    return logicalStyles(_objectSpread({
      minHeight: grow ? "max(".concat(minHeight, ", 100vh)") : minHeight,
      paddingTop: offset !== null && offset !== void 0 ? offset : 'var(--euiFixedHeadersOffset, 0)'
    }, style));
  }, [minHeight, grow, offset, style]);
  var innerPanelled = panelled !== null && panelled !== void 0 ? panelled : Boolean(sidebar.length > 0);
  var innerBordered = contentBorder !== null && contentBorder !== void 0 ? contentBorder : Boolean(sidebar.length > 0);
  var headerBottomBorder = bottomBorder !== null && bottomBorder !== void 0 ? bottomBorder : sidebar.length ? true : 'extended';
  var templateContext = useMemo(function () {
    return {
      sidebar: {
        paddingSize: paddingSize,
        responsive: responsive
      },
      header: {
        restrictWidth: restrictWidth,
        paddingSize: paddingSize,
        bottomBorder: headerBottomBorder
      },
      section: {
        restrictWidth: restrictWidth,
        paddingSize: paddingSize,
        color: panelled === false ? 'transparent' : 'plain',
        grow: true
      },
      emptyPrompt: {
        panelled: innerPanelled ? true : panelled,
        grow: true
      },
      bottomBar: {
        restrictWidth: restrictWidth,
        paddingSize: paddingSize,
        // pageInnerId may contain colons that are parsed as pseudo-elements if not escaped
        parent: "#".concat(pageInnerId.replaceAll(':', '\\:'))
      }
    };
  }, [pageInnerId, restrictWidth, responsive, paddingSize, panelled, innerPanelled, headerBottomBorder]);
  return ___EmotionJSX(TemplateContext.Provider, {
    value: templateContext
  }, ___EmotionJSX(EuiPageOuter, _extends({}, rest, {
    responsive: responsive,
    style: pageStyle,
    className: classes
  }), sidebar, ___EmotionJSX(EuiPageInner, _extends({}, mainProps, {
    component: component,
    id: pageInnerId,
    border: innerBordered,
    panelled: innerPanelled,
    responsive: responsive
  }), sections)));
};
var _EuiPageSidebar = function _EuiPageSidebar(props) {
  var _useContext = useContext(TemplateContext),
    sidebar = _useContext.sidebar;
  return ___EmotionJSX(EuiPageSidebar, _extends({}, sidebar, props));
};
var _EuiPageSection = function _EuiPageSection(props) {
  var _useContext2 = useContext(TemplateContext),
    section = _useContext2.section;
  return ___EmotionJSX(EuiPageSection, _extends({}, section, props));
};
var _EuiPageHeader = function _EuiPageHeader(props) {
  var _useContext3 = useContext(TemplateContext),
    header = _useContext3.header;
  return ___EmotionJSX(EuiPageHeader, _extends({}, header, props));
};
var _EuiPageEmptyPrompt = function _EuiPageEmptyPrompt(props) {
  var _useContext4 = useContext(TemplateContext),
    emptyPrompt = _useContext4.emptyPrompt;
  return ___EmotionJSX(EuiPageEmptyPrompt, _extends({}, emptyPrompt, props));
};
var _EuiPageBottomBar = function _EuiPageBottomBar(props) {
  var _useContext5 = useContext(TemplateContext),
    bottomBar = _useContext5.bottomBar;
  return ___EmotionJSX(EuiPageBottomBar, _extends({}, bottomBar, props));
};
export var EuiPageTemplate = Object.assign(_EuiPageTemplate, {
  Sidebar: _EuiPageSidebar,
  Header: _EuiPageHeader,
  Section: _EuiPageSection,
  BottomBar: _EuiPageBottomBar,
  EmptyPrompt: _EuiPageEmptyPrompt
});