import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiPagination } from './pagination';
import { jsx as ___EmotionJSX } from "@emotion/react";
var Pagination = function Pagination() {
  var _useState = useState(0),
    _useState2 = _slicedToArray(_useState, 2),
    activePage = _useState2[0],
    setActivePage = _useState2[1];
  return ___EmotionJSX(EuiPagination, {
    "aria-label": "Many pages example",
    pageCount: 22,
    activePage: activePage,
    onPageClick: function onPageClick(activePage) {
      return setActivePage(activePage);
    }
  });
};
describe('EuiPagination', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first mobile render', function () {
      cy.viewport(375, 667); // small breakpoint
      cy.mount(___EmotionJSX(Pagination, null));
      cy.get('nav.euiPagination').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when rendered using non-mobile breakpoint', function () {
      cy.viewport(1280, 800); //macbook-13
      cy.mount(___EmotionJSX(Pagination, null));
      cy.get('nav.euiPagination').should('exist');
      cy.checkAxe();
    });
  });
});