import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "paddingSize", "borderRadius", "color", "hasShadow", "hasBorder", "grow", "panelRef", "element"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { useEuiBackgroundColorCSS, useEuiPaddingCSS, BACKGROUND_COLORS, PADDING_SIZES } from '../../global_styling';
import { keysOf } from '../common';
import { euiPanelStyles } from './panel.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = PADDING_SIZES;

// Exported padding sizes and class names necessary for EuiPopover and EuiCard.
// Which currently will only maintain support for the original values until conversion.
var paddingSizeToClassNameMap = {
  none: null,
  s: 'paddingSmall',
  m: 'paddingMedium',
  l: 'paddingLarge'
};
var _SIZES = keysOf(paddingSizeToClassNameMap);
export var BORDER_RADII = ['none', 'm'];
export var COLORS = BACKGROUND_COLORS;
export var EuiPanel = function EuiPanel(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'm' : _ref$paddingSize,
    _ref$borderRadius = _ref.borderRadius,
    borderRadius = _ref$borderRadius === void 0 ? 'm' : _ref$borderRadius,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'plain' : _ref$color,
    _ref$hasShadow = _ref.hasShadow,
    hasShadow = _ref$hasShadow === void 0 ? true : _ref$hasShadow,
    _ref$hasBorder = _ref.hasBorder,
    hasBorder = _ref$hasBorder === void 0 ? false : _ref$hasBorder,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    panelRef = _ref.panelRef,
    element = _ref.element,
    rest = _objectWithoutProperties(_ref, _excluded);
  // Shadows are only allowed when there's a white background (plain)
  var canHaveShadow = !hasBorder && color === 'plain';
  var canHaveBorder = color === 'plain' || color === 'transparent';
  var styles = useEuiMemoizedStyles(euiPanelStyles);
  var cssStyles = [styles.euiPanel, grow && styles.grow, styles.radius[borderRadius], useEuiPaddingCSS()[paddingSize], useEuiBackgroundColorCSS()[color], canHaveShadow && hasShadow === true && styles.hasShadow, canHaveBorder && hasBorder === true && styles.hasBorder, rest.onClick && styles.isClickable];
  var classes = classNames('euiPanel', "euiPanel--".concat(color), _defineProperty({}, "euiPanel--".concat(paddingSizeToClassNameMap[paddingSize]), paddingSizeToClassNameMap[paddingSize]), className);
  if (rest.onClick && element !== 'div') {
    return ___EmotionJSX("button", _extends({
      ref: panelRef,
      className: classes,
      css: cssStyles
    }, rest), children);
  }
  return ___EmotionJSX("div", _extends({
    ref: panelRef,
    className: classes,
    css: cssStyles
  }, rest), children);
};