import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "closePopover", "anchorPosition", "attachToAnchor", "repositionToCrossAxis", "display", "panelPaddingSize", "closeOnScroll", "ownFocus", "disableFocusTrap", "focusTrapProps", "input", "fullWidth", "panelMinWidth", "onPanelResize", "inputRef", "panelRef"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useEffect, useCallback, useMemo, useRef, createContext } from 'react';
import { css } from '@emotion/react';
import classnames from 'classnames';
import { tabbable } from 'tabbable';
import { logicalCSS } from '../../global_styling';
import { keys, useCombinedRefs, useEuiTheme } from '../../services';
import { useResizeObserver } from '../observer/resize_observer';
import { EuiFocusTrap } from '../focus_trap';
import { euiFormMaxWidth } from '../form/form.styles';
import { EuiPopover } from './popover';
import { jsx as ___EmotionJSX } from "@emotion/react";
// Used by child components that want to know the parent popover width
export var EuiInputPopoverWidthContext = /*#__PURE__*/createContext(0);
export var EuiInputPopover = function EuiInputPopover(_ref) {
  var _props$panelProps;
  var children = _ref.children,
    className = _ref.className,
    closePopover = _ref.closePopover,
    _ref$anchorPosition = _ref.anchorPosition,
    anchorPosition = _ref$anchorPosition === void 0 ? 'downLeft' : _ref$anchorPosition,
    _ref$attachToAnchor = _ref.attachToAnchor,
    attachToAnchor = _ref$attachToAnchor === void 0 ? true : _ref$attachToAnchor,
    _ref$repositionToCros = _ref.repositionToCrossAxis,
    repositionToCrossAxis = _ref$repositionToCros === void 0 ? false : _ref$repositionToCros,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'block' : _ref$display,
    _ref$panelPaddingSize = _ref.panelPaddingSize,
    panelPaddingSize = _ref$panelPaddingSize === void 0 ? 's' : _ref$panelPaddingSize,
    _ref$closeOnScroll = _ref.closeOnScroll,
    closeOnScroll = _ref$closeOnScroll === void 0 ? false : _ref$closeOnScroll,
    _ref$ownFocus = _ref.ownFocus,
    ownFocus = _ref$ownFocus === void 0 ? false : _ref$ownFocus,
    _ref$disableFocusTrap = _ref.disableFocusTrap,
    disableFocusTrap = _ref$disableFocusTrap === void 0 ? false : _ref$disableFocusTrap,
    focusTrapProps = _ref.focusTrapProps,
    input = _ref.input,
    _ref$fullWidth = _ref.fullWidth,
    fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
    _ref$panelMinWidth = _ref.panelMinWidth,
    panelMinWidth = _ref$panelMinWidth === void 0 ? 0 : _ref$panelMinWidth,
    onPanelResize = _ref.onPanelResize,
    _inputRef = _ref.inputRef,
    _panelRef = _ref.panelRef,
    props = _objectWithoutProperties(_ref, _excluded);
  var classes = classnames('euiInputPopover', className);
  var euiTheme = useEuiTheme();
  var formMaxWidth = euiFormMaxWidth(euiTheme);

  /**
   * Ref setup
   */

  var popoverClassRef = useRef(null);
  // The inputEl state ensures that width is correctly tracked on initial load
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    inputEl = _useState2[0],
    setInputEl = _useState2[1];
  // The panelEl state ensures that width is correctly set every time the popover opens
  var _useState3 = useState(null),
    _useState4 = _slicedToArray(_useState3, 2),
    panelEl = _useState4[0],
    setPanelEl = _useState4[1];
  var inputRef = useCombinedRefs([setInputEl, _inputRef]);
  var panelRef = useCombinedRefs([setPanelEl, _panelRef]);

  /**
   * Sizing/width logic
   */

  var inputWidth = useResizeObserver(inputEl, 'width').width;
  var panelWidth = useMemo(function () {
    return inputWidth < panelMinWidth ? panelMinWidth : inputWidth;
  }, [panelMinWidth, inputWidth]);

  // Resize callback
  useEffect(function () {
    onPanelResize === null || onPanelResize === void 0 || onPanelResize(panelWidth);
  }, [panelWidth, onPanelResize]);
  useEffect(function () {
    if (panelEl) {
      // We have to modify the popover panel DOM node directly instead of using
      // `panelStyle`, as there's some weird positioning bugs on resize otherwise
      panelEl.style.inlineSize = "".concat(panelWidth, "px");
    }
  }, [panelEl, panelWidth]);
  useEffect(function () {
    // This fires on all input width changes regardless of minimum size, because on
    // right/center anchored popovers, the input width affects the position of the popover
    if (panelEl) {
      var _popoverClassRef$curr;
      (_popoverClassRef$curr = popoverClassRef.current) === null || _popoverClassRef$curr === void 0 || _popoverClassRef$curr.positionPopoverFluid();
    }
  }, [inputWidth, panelEl]);

  /**
   * Popover tab to close logic
   */

  var panelPropsOnKeyDown = (_props$panelProps = props.panelProps) === null || _props$panelProps === void 0 ? void 0 : _props$panelProps.onKeyDown;
  var onKeyDown = useCallback(function (event) {
    panelPropsOnKeyDown === null || panelPropsOnKeyDown === void 0 || panelPropsOnKeyDown(event);
    if (event.key === keys.TAB) {
      if (disableFocusTrap) {
        if (!ownFocus) {
          closePopover();
        }
      } else {
        var tabbableItems = tabbable(event.currentTarget).filter(function (el) {
          return !el.hasAttribute('data-focus-guard');
        });
        if (!tabbableItems.length) return;
        var tabbingFromLastItemInPopover = document.activeElement === tabbableItems[tabbableItems.length - 1];
        if (tabbingFromLastItemInPopover) {
          closePopover();
        }
      }
    }
  }, [disableFocusTrap, ownFocus, closePopover, panelPropsOnKeyDown]);

  /**
   * Optional close on scroll behavior
   */

  useEffect(function () {
    // When the popover opens, add a scroll listener to the page (& remove it after)
    if (closeOnScroll && panelEl) {
      var closePopoverOnScroll = function closePopoverOnScroll(event) {
        var scrollTarget = event.target;

        // Basic existence check
        if (!panelEl || !inputEl || !scrollTarget) {
          return;
        }
        // Do not close the popover if the input or popover itself was scrolled
        if (panelEl.contains(scrollTarget) || inputEl.contains(scrollTarget)) {
          return;
        }
        // Firefox will trigger a scroll event in many common situations (e.g. docs side nav)
        // when the options list div is appended to the DOM. To work around this, we should
        // check if the element that scrolled actually contains/will affect the input
        if (!scrollTarget.contains(inputEl)) {
          return;
        }
        closePopover();
      };

      // Kibana Cypress tests trigger a scroll event in many common situations when the options list div is appended
      // to the DOM; in testing it was always within 100ms, but setting a timeout here for 500ms to be safe
      var timeoutId = setTimeout(function () {
        window.addEventListener('scroll', closePopoverOnScroll, {
          passive: true,
          // for better performance as we won't call preventDefault
          capture: true // scroll events don't bubble, they must be captured instead
        });
      }, 500);
      return function () {
        window.removeEventListener('scroll', closePopoverOnScroll, {
          capture: true
        });
        clearTimeout(timeoutId);
      };
    }
  }, [closeOnScroll, closePopover, panelEl, inputEl]);
  return ___EmotionJSX(EuiPopover, _extends({
    className: classes,
    css: /*#__PURE__*/css(fullWidth ? undefined : logicalCSS('max-width', formMaxWidth), ";label:EuiInputPopover;"),
    display: display,
    button: input,
    popoverRef: inputRef,
    panelRef: panelRef,
    ref: popoverClassRef,
    closePopover: closePopover,
    anchorPosition: anchorPosition,
    attachToAnchor: attachToAnchor,
    repositionToCrossAxis: repositionToCrossAxis,
    panelPaddingSize: panelPaddingSize,
    ownFocus: ownFocus
  }, props, {
    panelProps: _objectSpread(_objectSpread({}, props.panelProps), {}, {
      onKeyDown: onKeyDown
    })
  }), ___EmotionJSX(EuiFocusTrap, _extends({
    clickOutsideDisables: true,
    disabled: disableFocusTrap
  }, focusTrapProps), ___EmotionJSX(EuiInputPopoverWidthContext.Provider, {
    value: panelWidth
  }, children)));
};