import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiPopover } from './popover';
import { EuiButtonEmpty } from '../button';
import { EuiText } from '../text';
import { jsx as ___EmotionJSX } from "@emotion/react";
var Popover = function Popover() {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var onButtonClick = function onButtonClick() {
    return setIsPopoverOpen(function (isPopoverOpen) {
      return !isPopoverOpen;
    });
  };
  var closePopover = function closePopover() {
    return setIsPopoverOpen(false);
  };
  var button = ___EmotionJSX(EuiButtonEmpty, {
    iconType: "documentation",
    iconSide: "right",
    onClick: onButtonClick
  }, "How it works");
  var popoverProps = {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  };
  return ___EmotionJSX(EuiPopover, popoverProps, ___EmotionJSX(EuiText, {
    style: {
      width: 300
    }
  }, ___EmotionJSX("p", null, "Popover content that\u2019s wider than the default width")));
};
beforeEach(function () {
  cy.mount(___EmotionJSX(Popover, null));
  cy.get('div.euiPopover__panel').should('not.exist');
});
describe('EuiPopover', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when popover is opened', function () {
      cy.get('button.euiButtonEmpty').click();
      cy.get('div.euiPopover__panel').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when popover is closed', function () {
      cy.get('button.euiButtonEmpty').click();
      cy.get('div.euiPopover__panel').should('exist');
      cy.get('button.euiButtonEmpty').click();
      cy.get('div.euiPopover__panel').should('not.exist');
      cy.checkAxe();
    });
  });
});