import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
var _excluded = ["anchorPosition", "button", "insert", "isOpen", "ownFocus", "children", "className", "closePopover", "panelClassName", "panelPaddingSize", "panelProps", "panelRef", "panelStyle", "popoverScreenReaderText", "popoverRef", "hasArrow", "arrowChildren", "repositionOnScroll", "repositionToCrossAxis", "zIndex", "attachToAnchor", "display", "offset", "onPositionChange", "buffer", "aria-label", "aria-labelledby", "container", "focusTrapProps", "initialFocus", "tabIndex"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import classNames from 'classnames';
import { focusable } from 'tabbable';
import { EuiFocusTrap } from '../focus_trap';
import { keys, getTransitionTimings, getWaitDuration, performOnFrame, htmlIdGenerator } from '../../services';
import { setMultipleRefs } from '../../services/hooks/useCombinedRefs';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiPortal } from '../portal';
import { EuiMutationObserver } from '../observer/mutation_observer';
import { findPopoverPosition, getElementZIndex } from '../../services/popover';
import { EuiI18n } from '../i18n';
import { EuiOutsideClickDetector } from '../outside_click_detector';
import { EuiPopoverArrow } from './popover_arrow';
import { euiPopoverStyles } from './popover.styles';
import { EuiPopoverPanel } from './popover_panel';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var popoverAnchorPosition = ['upCenter', 'upLeft', 'upRight', 'downCenter', 'downLeft', 'downRight', 'leftCenter', 'leftUp', 'leftDown', 'rightCenter', 'rightUp', 'rightDown'];
var anchorPositionToPopoverPositionMap = {
  up: 'top',
  right: 'right',
  down: 'bottom',
  left: 'left'
};
export function getPopoverPositionFromAnchorPosition(anchorPosition) {
  // maps the anchor position to the matching popover position
  // e.g. "upLeft" -> "top", "downRight" -> "bottom"

  // extract the first positional word from anchorPosition:
  // starts at the beginning (" ^ ") of anchorPosition and
  // captures all of the characters (" (.*?) ") until the
  // first capital letter (" [A-Z] ") is encountered
  var _ref = anchorPosition.match(/^(.*?)[A-Z]/),
    _ref2 = _slicedToArray(_ref, 2),
    primaryPosition = _ref2[1];
  return anchorPositionToPopoverPositionMap[primaryPosition];
}
export function getPopoverAlignFromAnchorPosition(anchorPosition) {
  // maps the gravity to the matching popover position
  // e.g. "upLeft" -> "left", "rightDown" -> "bottom"

  // extract the second positional word from anchorPosition:
  // starts a capture group at the first capital letter
  // and includes everything after it
  var _ref3 = anchorPosition.match(/([A-Z].*)/),
    _ref4 = _slicedToArray(_ref3, 2),
    align = _ref4[1];

  // this performs two tasks:
  // 1. normalizes the align position by lowercasing it
  // 2. `center` doesn't exist in the lookup map which converts it to `undefined` meaning no align
  return anchorPositionToPopoverPositionMap[align.toLowerCase()];
}
var DEFAULT_POPOVER_STYLES = {
  top: 50,
  left: 50
};
var returnFocusConfig = {
  preventScroll: true
};
var closingTransitionTime = 250; // TODO: DRY out var when converting to CSS-in-JS

export var EuiPopover = /*#__PURE__*/function (_Component) {
  function EuiPopover(props) {
    var _this;
    _classCallCheck(this, EuiPopover);
    _this = _callSuper(this, EuiPopover, [props]);
    _defineProperty(_this, "respositionTimeout", void 0);
    _defineProperty(_this, "strandedFocusTimeout", void 0);
    _defineProperty(_this, "closingTransitionTimeout", void 0);
    _defineProperty(_this, "closingTransitionAnimationFrame", void 0);
    _defineProperty(_this, "button", null);
    _defineProperty(_this, "panel", null);
    _defineProperty(_this, "descriptionId", htmlIdGenerator()());
    _defineProperty(_this, "closePopover", function () {
      if (_this.props.isOpen) {
        _this.props.closePopover();
      }
    });
    _defineProperty(_this, "onEscapeKey", function (event) {
      if (_this.props.isOpen) {
        event.preventDefault();
        event.stopPropagation();
        _this.closePopover();
        _this.handleStrandedFocus();
      }
    });
    _defineProperty(_this, "handleStrandedFocus", function () {
      _this.strandedFocusTimeout = window.setTimeout(function () {
        var _this$panel;
        // If `returnFocus` failed and focus was stranded,
        // attempt to manually restore focus to the toggle button.
        // The stranded focus is either in most cases on body but
        // it will be on the panel instead on mount when isOpen=true
        if (document.activeElement === document.body || (_this$panel = _this.panel) !== null && _this$panel !== void 0 && _this$panel.contains(document.activeElement) // if focus is on OR within this.panel
        ) {
          if (!_this.button) return;
          var focusableItems = focusable(_this.button);
          if (!focusableItems.length) return;
          var toggleButton = focusableItems[0];
          toggleButton.focus(returnFocusConfig);
        }
      }, closingTransitionTime);
    });
    _defineProperty(_this, "onKeyDown", function (event) {
      if (event.key === keys.ESCAPE) {
        _this.onEscapeKey(event);
      }
    });
    _defineProperty(_this, "onClickOutside", function (event) {
      // only close the popover if the event source isn't the anchor button
      // otherwise, it is up to the anchor to toggle the popover's open status
      if (_this.button && _this.button.contains(event.target) === false) {
        _this.closePopover();
      }
    });
    _defineProperty(_this, "onOpenPopover", function () {
      clearTimeout(_this.strandedFocusTimeout);
      clearTimeout(_this.closingTransitionTimeout);
      if (_this.closingTransitionAnimationFrame) {
        cancelAnimationFrame(_this.closingTransitionAnimationFrame);
      }
      // We need to set this state a beat after the render takes place, so that the CSS
      // transition can take effect.
      _this.closingTransitionAnimationFrame = window.requestAnimationFrame(function () {
        _this.setState({
          isOpening: true
        });
      });

      // for each child element of `this.panel`, find any transition duration we should wait for before stabilizing
      var _Array$prototype$slic = Array.prototype.slice.call(_this.panel ? [_this.panel].concat(_toConsumableArray(Array.from(_this.panel.children))) : []).reduce(function (_ref5, element) {
          var durationMatch = _ref5.durationMatch,
            delayMatch = _ref5.delayMatch;
          var transitionTimings = getTransitionTimings(element);
          return {
            durationMatch: Math.max(durationMatch, transitionTimings.durationMatch),
            delayMatch: Math.max(delayMatch, transitionTimings.delayMatch)
          };
        }, {
          durationMatch: 0,
          delayMatch: 0
        }),
        durationMatch = _Array$prototype$slic.durationMatch,
        delayMatch = _Array$prototype$slic.delayMatch;
      clearTimeout(_this.respositionTimeout);
      _this.respositionTimeout = window.setTimeout(function () {
        _this.setState({
          isOpenStable: true
        }, function () {
          _this.positionPopoverFixed();
        });
      }, durationMatch + delayMatch);
    });
    _defineProperty(_this, "onMutation", function (records) {
      var waitDuration = getWaitDuration(records);
      _this.positionPopoverFixed();
      performOnFrame(waitDuration, _this.positionPopoverFixed);
    });
    _defineProperty(_this, "positionPopover", function (allowEnforcePosition) {
      if (_this.button == null || _this.panel == null) return;
      var _ref6 = _this.props,
        anchorPosition = _ref6.anchorPosition,
        _ref6$offset = _ref6.offset,
        offset = _ref6$offset === void 0 ? 0 : _ref6$offset;
      var position = getPopoverPositionFromAnchorPosition(anchorPosition);
      var forcePosition = undefined;
      if (allowEnforcePosition && _this.state.isOpenStable && _this.state.openPosition != null) {
        position = _this.state.openPosition;
        forcePosition = true;
      }
      var _findPopoverPosition = findPopoverPosition({
          container: _this.props.container,
          position: position,
          forcePosition: forcePosition,
          align: getPopoverAlignFromAnchorPosition(anchorPosition),
          anchor: _this.button,
          popover: _this.panel,
          offset: _this.props.attachToAnchor ? offset : _this.props.hasArrow ? 16 + offset : 8 + offset,
          arrowConfig: _this.props.hasArrow ? {
            arrowWidth: 24,
            arrowBuffer: 10
          } : {
            arrowWidth: 0,
            arrowBuffer: 0
          },
          returnBoundingBox: _this.props.attachToAnchor,
          allowCrossAxis: _this.props.repositionToCrossAxis,
          buffer: _this.props.buffer
        }),
        top = _findPopoverPosition.top,
        left = _findPopoverPosition.left,
        foundPosition = _findPopoverPosition.position,
        arrow = _findPopoverPosition.arrow;

      // the popover's z-index must inherit from the button
      // this keeps a button's popover under a flyout that would cover the button
      // but a popover triggered inside a flyout will appear over that flyout
      var zIndexProp = _this.props.zIndex;
      var zIndex = zIndexProp == null ? getElementZIndex(_this.button, _this.panel) + 2000 : zIndexProp;
      var popoverStyles = _objectSpread(_objectSpread({}, _this.props.panelStyle), {}, {
        top: top,
        left: left,
        zIndex: zIndex
      });
      var willRenderArrow = !_this.props.attachToAnchor && _this.props.hasArrow;
      var arrowStyles = willRenderArrow ? arrow : undefined;
      var arrowPosition = foundPosition;
      _this.props.onPositionChange && _this.props.onPositionChange(arrowPosition);
      _this.setState({
        popoverStyles: popoverStyles,
        arrowStyles: arrowStyles,
        arrowPosition: arrowPosition,
        openPosition: foundPosition
      });
    });
    _defineProperty(_this, "positionPopoverFixed", function () {
      _this.positionPopover(true);
    });
    _defineProperty(_this, "positionPopoverFluid", function () {
      _this.positionPopover(false);
    });
    _defineProperty(_this, "panelRef", function (node) {
      _this.panel = node;
      _this.props.panelRef && _this.props.panelRef(node);
      if (node == null) {
        // panel has unmounted, restore the state defaults
        _this.setState({
          popoverStyles: DEFAULT_POPOVER_STYLES,
          arrowStyles: {},
          arrowPosition: null,
          openPosition: null,
          isOpenStable: false
        });
        window.removeEventListener('resize', _this.positionPopoverFluid);
      } else {
        // panel is coming into existence
        _this.positionPopoverFluid();
        window.addEventListener('resize', _this.positionPopoverFluid);
      }
    });
    _defineProperty(_this, "popoverRef", function (node) {
      _this.button = node;
      setMultipleRefs([_this.props.popoverRef], node);
    });
    _this.state = {
      prevProps: {
        isOpen: props.isOpen
      },
      suppressingPopover: props.isOpen,
      // only suppress if created with isOpen=true
      isClosing: false,
      isOpening: false,
      popoverStyles: DEFAULT_POPOVER_STYLES,
      arrowStyles: {},
      arrowPosition: null,
      openPosition: null,
      // once a stable position has been found, keep the contents on that side
      isOpenStable: false // wait for any initial opening transitions to finish before marking as stable
    };
    return _this;
  }
  _inherits(EuiPopover, _Component);
  return _createClass(EuiPopover, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;
      if (this.state.suppressingPopover) {
        // component was created with isOpen=true; now that it's mounted
        // stop suppressing and start opening
        this.setState({
          suppressingPopover: false,
          isOpening: true
        }, function () {
          _this2.onOpenPopover();
        });
      }
      if (this.props.repositionOnScroll) {
        window.addEventListener('scroll', this.positionPopoverFixed, true);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this3 = this;
      // The popover is being opened.
      if (!prevProps.isOpen && this.props.isOpen) {
        this.onOpenPopover();
      }

      // ensure recalculation of panel position on prop updates
      if (this.props.isOpen && (prevProps.anchorPosition !== this.props.anchorPosition || prevProps.buffer !== this.props.buffer || prevProps.offset !== this.props.offset || prevProps.panelPaddingSize !== this.props.panelPaddingSize)) {
        this.positionPopoverFluid();
      }

      // update scroll listener
      if (prevProps.repositionOnScroll !== this.props.repositionOnScroll) {
        if (this.props.repositionOnScroll) {
          window.addEventListener('scroll', this.positionPopoverFixed, true);
        } else {
          window.removeEventListener('scroll', this.positionPopoverFixed, true);
        }
      }

      // The popover is being closed.
      if (prevProps.isOpen && !this.props.isOpen) {
        // If the user has just closed the popover, queue up the removal of the content after the
        // transition is complete.
        this.closingTransitionTimeout = window.setTimeout(function () {
          _this3.setState({
            isClosing: false
          });
        }, closingTransitionTime);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      window.removeEventListener('scroll', this.positionPopoverFixed, true);
      clearTimeout(this.respositionTimeout);
      clearTimeout(this.strandedFocusTimeout);
      clearTimeout(this.closingTransitionTimeout);
      cancelAnimationFrame(this.closingTransitionAnimationFrame);
    }
  }, {
    key: "render",
    value: function render() {
      var _panelProps$tabIndex,
        _this4 = this;
      var _this$props = this.props,
        anchorPosition = _this$props.anchorPosition,
        button = _this$props.button,
        insert = _this$props.insert,
        isOpen = _this$props.isOpen,
        ownFocus = _this$props.ownFocus,
        children = _this$props.children,
        className = _this$props.className,
        closePopover = _this$props.closePopover,
        panelClassName = _this$props.panelClassName,
        panelPaddingSize = _this$props.panelPaddingSize,
        panelProps = _this$props.panelProps,
        panelRef = _this$props.panelRef,
        panelStyle = _this$props.panelStyle,
        popoverScreenReaderText = _this$props.popoverScreenReaderText,
        popoverRef = _this$props.popoverRef,
        hasArrow = _this$props.hasArrow,
        arrowChildren = _this$props.arrowChildren,
        repositionOnScroll = _this$props.repositionOnScroll,
        repositionToCrossAxis = _this$props.repositionToCrossAxis,
        zIndex = _this$props.zIndex,
        attachToAnchor = _this$props.attachToAnchor,
        display = _this$props.display,
        offset = _this$props.offset,
        onPositionChange = _this$props.onPositionChange,
        buffer = _this$props.buffer,
        ariaLabel = _this$props['aria-label'],
        ariaLabelledBy = _this$props['aria-labelledby'],
        container = _this$props.container,
        focusTrapProps = _this$props.focusTrapProps,
        initialFocusProp = _this$props.initialFocus,
        _tabIndexProp = _this$props.tabIndex,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var tabIndexProp = (_panelProps$tabIndex = panelProps === null || panelProps === void 0 ? void 0 : panelProps.tabIndex) !== null && _panelProps$tabIndex !== void 0 ? _panelProps$tabIndex : _tabIndexProp;
      var styles = euiPopoverStyles();
      var popoverStyles = [styles.euiPopover, {
        display: display,
        label: display
      }];
      var classes = classNames('euiPopover', {
        'euiPopover-isOpen': this.state.isOpening
      }, className);
      var showArrow = hasArrow && !attachToAnchor;
      var panel;
      if (!this.state.suppressingPopover && (isOpen || this.state.isClosing)) {
        var tabIndex = tabIndexProp;
        var initialFocus = initialFocusProp;
        var ariaDescribedby;
        var ariaLive;
        var panelAriaModal = panelProps !== null && panelProps !== void 0 && panelProps.hasOwnProperty('aria-modal') ? panelProps['aria-modal'] : 'true';
        var panelRole = panelProps !== null && panelProps !== void 0 && panelProps.hasOwnProperty('role') ? panelProps.role : 'dialog';
        if (ownFocus || panelAriaModal !== 'true') {
          tabIndex = tabIndexProp !== null && tabIndexProp !== void 0 ? tabIndexProp : 0;
          ariaLive = 'off';
          if (!initialFocus) {
            initialFocus = function initialFocus() {
              return _this4.panel;
            };
          }
        } else {
          ariaLive = 'assertive';
        }
        var focusTrapScreenReaderText;
        if (ownFocus || popoverScreenReaderText) {
          ariaDescribedby = this.descriptionId;
          focusTrapScreenReaderText = ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", {
            id: this.descriptionId
          }, ownFocus && ___EmotionJSX(EuiI18n, {
            token: "euiPopover.screenReaderAnnouncement",
            default: "You are in a dialog. Press Escape, or tap/click outside the dialog to close."
          }), popoverScreenReaderText));
        }
        var returnFocus = this.state.isOpenStable ? returnFocusConfig : false;
        panel = ___EmotionJSX(EuiPortal, insert && {
          insert: insert
        }, ___EmotionJSX(EuiFocusTrap, _extends({
          clickOutsideDisables: true,
          onClickOutside: this.onClickOutside,
          returnFocus: returnFocus // Ignore temporary state of indecisive focus
          ,
          initialFocus: initialFocus,
          onEscapeKey: this.onEscapeKey,
          disabled: !ownFocus || !this.state.isOpenStable || this.state.isClosing
        }, focusTrapProps), ___EmotionJSX(EuiPopoverPanel, _extends({}, panelProps, {
          panelRef: this.panelRef,
          isOpen: this.state.isOpening,
          position: this.state.arrowPosition,
          isAttached: attachToAnchor,
          className: classNames(panelClassName, panelProps === null || panelProps === void 0 ? void 0 : panelProps.className),
          hasShadow: false,
          paddingSize: panelPaddingSize,
          tabIndex: tabIndex,
          "aria-live": ariaLive,
          role: panelRole,
          "aria-label": ariaLabel,
          "aria-labelledby": ariaLabelledBy,
          "aria-modal": panelAriaModal,
          "aria-describedby": ariaDescribedby,
          style: _objectSpread(_objectSpread({}, this.state.popoverStyles), {}, {
            // Adding `will-change` to reduce risk of a blurry animation in Chrome 86+
            willChange: !this.state.isOpenStable ? 'transform, opacity' : undefined
          })
        }), showArrow && this.state.arrowPosition && ___EmotionJSX(EuiPopoverArrow, {
          position: this.state.arrowPosition,
          style: this.state.arrowStyles
        }, arrowChildren), focusTrapScreenReaderText, ___EmotionJSX(EuiMutationObserver, {
          observerOptions: {
            attributes: true,
            // element attribute changes
            childList: true,
            // added/removed elements
            characterData: true,
            // text changes
            subtree: true // watch all child elements
          },
          onMutation: this.onMutation
        }, function (mutationRef) {
          return ___EmotionJSX("div", {
            ref: mutationRef
          }, children);
        }))));
      }

      // react-focus-on and related do not register outside click detection
      // when disabled, so we still need to conditionally check for that ourselves
      if (ownFocus) {
        return ___EmotionJSX("div", _extends({
          css: popoverStyles,
          className: classes,
          ref: this.popoverRef
        }, rest), button instanceof HTMLElement ? null : button, panel);
      } else {
        return ___EmotionJSX(EuiOutsideClickDetector, {
          onOutsideClick: this.closePopover
        }, ___EmotionJSX("div", _extends({
          css: popoverStyles,
          className: classes,
          ref: this.popoverRef,
          onKeyDown: this.onKeyDown
        }, rest), button instanceof HTMLElement ? null : button, panel));
      }
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (prevState.prevProps.isOpen && !nextProps.isOpen) {
        return {
          prevProps: {
            isOpen: nextProps.isOpen
          },
          isClosing: true,
          isOpening: false
        };
      }
      if (prevState.prevProps.isOpen !== nextProps.isOpen) {
        return {
          prevProps: {
            isOpen: nextProps.isOpen
          }
        };
      }
      return null;
    }
  }]);
}(Component);
_defineProperty(EuiPopover, "defaultProps", {
  isOpen: false,
  ownFocus: true,
  repositionToCrossAxis: true,
  anchorPosition: 'downCenter',
  panelPaddingSize: 'm',
  hasArrow: true,
  display: 'inline-block'
});