import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "position"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { euiPopoverArrowStyles } from './_popover_arrow.styles';
import { useEuiTheme } from '../../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var POSITIONS = ['top', 'left', 'right', 'bottom'];
export var EuiPopoverArrow = function EuiPopoverArrow(_ref) {
  var children = _ref.children,
    position = _ref.position,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = useEuiTheme();
  var styles = euiPopoverArrowStyles(euiTheme);
  var cssStyles = [styles.euiPopoverArrow, styles[position]];
  return ___EmotionJSX("div", _extends({
    className: "euiPopover__arrow",
    "data-popover-arrow": position,
    css: cssStyles
  }, rest), children);
};