/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicals, logicalSizeCSS } from '../../../global_styling';
export var popoverArrowSize = 'm';
export var euiPopoverArrowStyles = function euiPopoverArrowStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var borderColor = 'var(--euiPopoverBackgroundColor)';
  var arrowSize = euiTheme.size[popoverArrowSize];
  return {
    // Base
    euiPopoverArrow: /*#__PURE__*/css("position:absolute;", logicalSizeCSS(0, 0), "&::before{content:'';position:absolute;", logicalSizeCSS(0, 0), ";};label:euiPopoverArrow;"),
    // POSITIONS
    top: /*#__PURE__*/css("&::before{", logicals.bottom, ":-", arrowSize, ";", logicals['border-left'], ":", arrowSize, " solid transparent;", logicals['border-right'], ":", arrowSize, " solid transparent;", logicals['border-top'], ":", arrowSize, " solid ", borderColor, ";};label:top;"),
    bottom: /*#__PURE__*/css("&::before{", logicals.top, ":-", arrowSize, ";", logicals['border-left'], ":", arrowSize, " solid transparent;", logicals['border-right'], ":", arrowSize, " solid transparent;", logicals['border-bottom'], ":", arrowSize, " solid ", borderColor, ";};label:bottom;"),
    left: /*#__PURE__*/css("&::before{", logicals.top, ":50%;", logicals.right, ":-", arrowSize, ";", logicals['border-top'], ":", arrowSize, " solid transparent;", logicals['border-bottom'], ":", arrowSize, " solid transparent;", logicals['border-left'], ":", arrowSize, " solid ", borderColor, ";};label:left;"),
    right: /*#__PURE__*/css("&::before{", logicals.top, ":50%;", logicals.left, ":-", arrowSize, ";", logicals['border-top'], ":", arrowSize, " solid transparent;", logicals['border-bottom'], ":", arrowSize, " solid transparent;", logicals['border-right'], ":", arrowSize, " solid ", borderColor, ";};label:right;")
  };
};