import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "paddingSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext } from 'react';
import classNames from 'classnames';
import { useEuiPaddingCSS } from '../../global_styling';
import { useEuiTheme } from '../../services';
import { euiPopoverFooterStyles } from './popover_footer.styles';
import { EuiPopoverPanelContext } from './popover_panel/_popover_panel';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiPopoverFooter = function EuiPopoverFooter(_ref) {
  var children = _ref.children,
    className = _ref.className,
    paddingSize = _ref.paddingSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = useContext(EuiPopoverPanelContext),
    panelPadding = _useContext.paddingSize;
  var euiTheme = useEuiTheme();
  var styles = euiPopoverFooterStyles(euiTheme);
  var paddingStyles = useEuiPaddingCSS();
  var cssStyles = [styles.euiPopoverFooter, styles.panelPaddingSizes[panelPadding], paddingStyles[paddingSize || panelPadding] // If a paddingSize is not directly provided, inherit from the EuiPopoverPanel
  ];
  var classes = classNames('euiPopoverFooter', className);
  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), children);
};