import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "isOpen", "isAttached", "position"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { createContext, useMemo } from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { EuiPanel } from '../../panel/panel';
import { euiPopoverPanelStyles } from './_popover_panel.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var DEFAULT_PANEL_PADDING_SIZE = 'l';
export var EuiPopoverPanelContext = /*#__PURE__*/createContext({
  paddingSize: DEFAULT_PANEL_PADDING_SIZE
});
/**
 * *INTERNAL ONLY*
 * Purely for re-use of styling
 */
export var EuiPopoverPanel = function EuiPopoverPanel(_ref) {
  var children = _ref.children,
    className = _ref.className,
    isOpen = _ref.isOpen,
    isAttached = _ref.isAttached,
    position = _ref.position,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiPopover__panel', className);
  var euiThemeContext = useEuiTheme();
  var cssStyles = useMemo(function () {
    var styles = euiPopoverPanelStyles(euiThemeContext);
    var colorMode = euiThemeContext.colorMode.toLowerCase();
    var sharedStyles = [styles.euiPopover__panel, styles[colorMode], isOpen && styles.isOpen];
    if (isAttached) {
      return [].concat(sharedStyles, [styles.isAttached.isAttached, position && styles.isAttached[position]]);
    }
    return [].concat(sharedStyles, [styles.hasTransform.hasTransform, isOpen && position && styles.hasTransform[position]]);
  }, [euiThemeContext, isOpen, position, isAttached]);
  return ___EmotionJSX(EuiPopoverPanelContext.Provider, {
    value: {
      paddingSize: rest.paddingSize || DEFAULT_PANEL_PADDING_SIZE
    }
  }, ___EmotionJSX(EuiPanel, _extends({
    className: classes,
    css: cssStyles,
    "data-popover-panel": true,
    "data-popover-open": isOpen || undefined
  }, rest), children));
};