function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiShadow, euiShadowFlat, euiShadowMedium } from '../../../themes/amsterdam/global_styling/mixins';
import { tint } from '../../../services';
import { euiCanAnimate, logicalCSS, mathWithUnits } from '../../../global_styling';
export var openAnimationTiming = 'slow';

/**
 * 1. Can expand further, but it looks weird if it's smaller than the originating button.
 * 2. Animation happens on the panel. But don't animate position when using the attached mode like for inputs
 * 3. Make sure the panel stays within the window.
 * 4. Make the popover lighter on dark mode (too hard to distinguish from plain bgs otherwise), and set a CSS var for the arrow to use
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "j5y6yx-isOpen",
  styles: "opacity:1;pointer-events:auto;label:isOpen;"
} : {
  name: "j5y6yx-isOpen",
  styles: "opacity:1;pointer-events:auto;label:isOpen;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiPopoverPanelStyles = function euiPopoverPanelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var translateDistance = euiTheme.size.s;
  var animationSpeed = euiTheme.animation[openAnimationTiming];
  var opacityTransition = "opacity ".concat(euiTheme.animation.bounce, " ").concat(animationSpeed);
  var transformTransition = "transform ".concat(euiTheme.animation.bounce, " ").concat(mathWithUnits(animationSpeed, function (x) {
    return x + 100;
  }));
  return {
    // Base
    euiPopover__panel: /*#__PURE__*/css("position:absolute;", logicalCSS('min-width', "".concat(euiTheme.base * 7, "px")), logicalCSS('max-width', "calc(100vw - ".concat(euiTheme.size.xl, ")")), "backface-visibility:hidden;pointer-events:none;opacity:0;background-color:var(--euiPopoverBackgroundColor);", euiCanAnimate, "{transition:", opacityTransition, ",", transformTransition, ";}&:focus{outline-offset:0;};label:euiPopover__panel;"),
    isOpen: _ref,
    /* 4 */
    light: /*#__PURE__*/css("--euiPopoverBackgroundColor:", euiTheme.colors.emptyShade, ";;label:light;"),
    dark: /*#__PURE__*/css("--euiPopoverBackgroundColor:", tint(euiTheme.colors.emptyShade, 0.025), ";;label:dark;"),
    // Regular popover with an arrow, a transform animation/transition, and a
    // drop shadow via `filter` (which automatically handles the arrow)
    hasTransform: {
      hasTransform: /*#__PURE__*/css("transform:translateY(0) translateX(0) translateZ(0);", euiShadowMedium(euiThemeContext, {
        property: 'filter'
      }), " ", euiCanAnimate, "{transition:", opacityTransition, ",", transformTransition, ";};label:hasTransform;"),
      // Positions
      top: /*#__PURE__*/css("transform:translateY(", translateDistance, ") translateZ(0);;label:top;"),
      bottom: /*#__PURE__*/css("transform:translateY(-", translateDistance, ") translateZ(0);;label:bottom;"),
      left: /*#__PURE__*/css("transform:translateX(", translateDistance, ") translateZ(0);;label:left;"),
      right: /*#__PURE__*/css("transform:translateX(-", translateDistance, ") translateZ(0);;label:right;")
    },
    // No arrow, transform, or filters
    isAttached: {
      isAttached: /*#__PURE__*/css(euiCanAnimate, "{transition:", opacityTransition, ";};label:isAttached;"),
      top: /*#__PURE__*/css(euiShadowFlat(euiThemeContext), ";;label:top;"),
      bottom: /*#__PURE__*/css(euiShadow(euiThemeContext, 'm'), ";;label:bottom;"),
      get left() {
        return this.bottom;
      },
      get right() {
        return this.bottom;
      }
    }
  };
};