import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["button"];
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import { EuiPopover } from './popover';
import { EuiPortal } from '../portal';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * Injects the EuiPopover next to the button via EuiPortal
 * then the button element is moved into the popover dom.
 * On unmount, the button is moved back to its original location.
 */
export var EuiWrappingPopover = /*#__PURE__*/function (_Component) {
  function EuiWrappingPopover() {
    var _this;
    _classCallCheck(this, EuiWrappingPopover);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiWrappingPopover, [].concat(args));
    _defineProperty(_this, "portal", null);
    _defineProperty(_this, "setPortalRef", function (node) {
      _this.portal = node;
    });
    _defineProperty(_this, "setAnchorRef", function (node) {
      node === null || node === void 0 || node.insertAdjacentElement('beforebegin', _this.props.button);
    });
    return _this;
  }
  _inherits(EuiWrappingPopover, _Component);
  return _createClass(EuiWrappingPopover, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.props.button.parentNode) {
        if (this.portal) {
          this.portal.insertAdjacentElement('beforebegin', this.props.button);
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        button = _this$props.button,
        rest = _objectWithoutProperties(_this$props, _excluded);
      return ___EmotionJSX(EuiPortal, {
        portalRef: this.setPortalRef,
        insert: {
          sibling: this.props.button,
          position: 'after'
        }
      }, ___EmotionJSX(EuiPopover, _extends({}, rest, {
        button: ___EmotionJSX("div", {
          ref: this.setAnchorRef,
          className: "euiWrappingPopover__anchor"
        })
      })));
    }
  }]);
}(Component);