import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiButton } from '../button';
import { EuiPortal } from './portal';
import { jsx as ___EmotionJSX } from "@emotion/react";
var Portal = function Portal() {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPortalVisible = _useState2[0],
    setIsPortalVisible = _useState2[1];
  var togglePortal = function togglePortal() {
    setIsPortalVisible(!isPortalVisible);
  };
  var closePortal = function closePortal() {
    setIsPortalVisible(false);
  };
  var customPortal;
  if (isPortalVisible) {
    customPortal = ___EmotionJSX(EuiPortal, null, ___EmotionJSX("div", null, "This is the portal. Click anywhere to close."), ___EmotionJSX(EuiButton, {
      onClick: closePortal
    }, "Close portal"));
  }
  return ___EmotionJSX("div", null, ___EmotionJSX(EuiButton, {
    onClick: togglePortal
  }, "View guide"), customPortal);
};
describe('EuiPortal', function () {
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount(___EmotionJSX(Portal, null));
    cy.get('div[data-relative-to-header="above"]').should('not.exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations after the portal is activated', function () {
      cy.get('button[type="button"]').contains('View guide').realClick();
      cy.get('div[data-euiportal="true"]').should('exist');
      cy.checkAxe();
    });
  });
});