import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * NOTE: We can't test this component because Enzyme doesn't support rendering
 * into portals.
 */

import React, { Component } from 'react';
import { createPortal } from 'react-dom';
import { EuiNestedThemeContext } from '../../services';
import { usePropsWithComponentDefaults } from '../provider/component_defaults';
import { jsx as ___EmotionJSX } from "@emotion/react";
var INSERT_POSITIONS = ['after', 'before'];
var insertPositions = {
  after: 'afterend',
  before: 'beforebegin'
};
export var EuiPortal = function EuiPortal(props) {
  var propsWithDefaults = usePropsWithComponentDefaults('EuiPortal', props);
  return ___EmotionJSX(EuiPortalClass, propsWithDefaults);
};
export var EuiPortalClass = /*#__PURE__*/function (_Component) {
  function EuiPortalClass(props) {
    var _this;
    _classCallCheck(this, EuiPortalClass);
    _this = _callSuper(this, EuiPortalClass, [props]);
    _this.state = {
      portalNode: null
    };
    return _this;
  }
  _inherits(EuiPortalClass, _Component);
  return _createClass(EuiPortalClass, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var insert = this.props.insert;
      var portalNode = document.createElement('div');
      portalNode.dataset.euiportal = 'true';
      if (insert == null) {
        // no insertion defined, append to body
        document.body.appendChild(portalNode);
      } else {
        // inserting before or after an element
        var sibling = insert.sibling,
          position = insert.position;
        sibling.insertAdjacentElement(insertPositions[position], portalNode);
      }
      this.setThemeColor(portalNode);
      this.updatePortalRef(portalNode);

      // Update state with portalNode to intentionally trigger component rerender
      // and call createPortal with correct root element in render()
      this.setState({
        portalNode: portalNode
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var portalNode = this.state.portalNode;
      if (portalNode !== null && portalNode !== void 0 && portalNode.parentNode) {
        portalNode.parentNode.removeChild(portalNode);
      }
      this.updatePortalRef(null);
    }

    // Set the inherited color of the portal based on the wrapping EuiThemeProvider
  }, {
    key: "setThemeColor",
    value: function setThemeColor(portalNode) {
      if (this.context) {
        var _this$context = this.context,
          hasDifferentColorFromGlobalTheme = _this$context.hasDifferentColorFromGlobalTheme,
          colorClassName = _this$context.colorClassName;
        if (hasDifferentColorFromGlobalTheme && this.props.insert == null) {
          portalNode.classList.add(colorClassName);
        }
      }
    }
  }, {
    key: "updatePortalRef",
    value: function updatePortalRef(ref) {
      if (this.props.portalRef) {
        this.props.portalRef(ref);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var portalNode = this.state.portalNode;
      if (!portalNode) {
        return null;
      }
      return /*#__PURE__*/createPortal(this.props.children, portalNode);
    }
  }]);
}(Component);
_defineProperty(EuiPortalClass, "contextType", EuiNestedThemeContext);