import _extends from "@babel/runtime/helpers/extends";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React from 'react';
import { EuiProgress } from './progress';
import { EuiSpacer } from '../spacer';
import { jsx as ___EmotionJSX } from "@emotion/react";
var ProgressCommonProps = {
  color: 'success',
  max: 100
};
var ProgressBars = function ProgressBars() {
  return ___EmotionJSX(React.Fragment, null, ___EmotionJSX("div", {
    "data-test-subj": "cy-progress-1"
  }, ___EmotionJSX(EuiProgress, _extends({
    valueText: true,
    size: "xs",
    value: 0
  }, ProgressCommonProps))), ___EmotionJSX("div", {
    "data-test-subj": "cy-progress-2"
  }, ___EmotionJSX(EuiProgress, _extends({
    valueText: true,
    size: "s",
    value: 33
  }, ProgressCommonProps))), ___EmotionJSX("div", {
    "data-test-subj": "cy-progress-3"
  }, ___EmotionJSX(EuiProgress, _extends({
    valueText: true,
    size: "m",
    value: 66
  }, ProgressCommonProps))), ___EmotionJSX("div", {
    "data-test-subj": "cy-progress-4"
  }, ___EmotionJSX(EuiProgress, _extends({
    valueText: true,
    size: "l",
    value: 100
  }, ProgressCommonProps))), ___EmotionJSX("div", {
    "data-test-subj": "cy-progress-5"
  }, ___EmotionJSX(EuiProgress, _extends({
    valueText: true,
    label: "Basic percentage",
    size: "l",
    value: 100
  }, ProgressCommonProps))), ___EmotionJSX(EuiSpacer, {
    size: "m"
  }), ___EmotionJSX("div", {
    "data-test-subj": "cy-progress-infinite"
  }, ___EmotionJSX(EuiProgress, {
    valueText: true,
    size: "l",
    color: "success"
  })));
};
beforeEach(function () {
  cy.viewport(1024, 768); // medium breakpoint
  cy.realMount(___EmotionJSX(ProgressBars, null));
  cy.get('div[data-test-subj="cy-progress-1"]').should('exist');
});
describe('EuiProgress', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('displays correct progress values and labels', function () {
      cy.get('div[data-test-subj="cy-progress-1"] span.euiProgress__valueText').contains('0');
      cy.get('div[data-test-subj="cy-progress-2"] span.euiProgress__valueText').contains('33');
      cy.get('div[data-test-subj="cy-progress-3"] span.euiProgress__valueText').contains('66');
      cy.get('div[data-test-subj="cy-progress-4"] span.euiProgress__valueText').contains('100');
      cy.get('div[data-test-subj="cy-progress-5"] span.euiProgress__label').contains('Basic percentage');
      cy.get('div[data-test-subj="cy-progress-5"] span.euiProgress__valueText').contains('100');
      cy.get('div[data-test-subj="cy-progress-infinite"] span.euiProgress__valueText').should('not.exist');
    });
  });
});