/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { createContext, useContext } from 'react';

/**
 * This util creates a context for EuiProviders to use and determine if they're
 * the only (top-most) EuiProvider in the app. If they aren't (i.e., they're
 * nested within another EuiProvider) we should throw a warning and not
 * render instantiate the nested EuiProvider.
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiNestedProviderContext = /*#__PURE__*/createContext(false);
export var EuiProviderNestedCheck = function EuiProviderNestedCheck(_ref) {
  var children = _ref.children;
  return ___EmotionJSX(EuiNestedProviderContext.Provider, {
    value: true
  }, children);
};
export var useIsNestedEuiProvider = function useIsNestedEuiProvider() {
  return !!useContext(EuiNestedProviderContext);
};