import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { useState, useEffect } from 'react';
export var COLOR_MODE_MEDIA_QUERY = '(prefers-color-scheme: dark)';
export var EuiSystemColorModeProvider = function EuiSystemColorModeProvider(_ref) {
  var children = _ref.children;
  // Check typeof and use optional chaining for SSR or test environments
  var _useState = useState(function () {
      var _window$matchMedia, _window;
      return typeof window !== 'undefined' && (_window$matchMedia = (_window = window).matchMedia) !== null && _window$matchMedia !== void 0 && (_window$matchMedia = _window$matchMedia.call(_window, COLOR_MODE_MEDIA_QUERY)) !== null && _window$matchMedia !== void 0 && _window$matchMedia.matches ? 'DARK' : 'LIGHT';
    }),
    _useState2 = _slicedToArray(_useState, 2),
    systemColorMode = _useState2[0],
    setSystemColorMode = _useState2[1];

  // Listen for system changes
  useEffect(function () {
    var _window$matchMedia2, _window2, _window$matchMedia2$c, _window$matchMedia2$c2;
    var eventListener = function eventListener(event) {
      setSystemColorMode(event.matches ? 'DARK' : 'LIGHT');
    };

    // Optional chaining here is for test environments - SSR should not run useEffect
    (_window$matchMedia2 = (_window2 = window).matchMedia) === null || _window$matchMedia2 === void 0 || (_window$matchMedia2$c = (_window$matchMedia2$c2 = _window$matchMedia2.call(_window2, COLOR_MODE_MEDIA_QUERY)).addEventListener) === null || _window$matchMedia2$c === void 0 || _window$matchMedia2$c.call(_window$matchMedia2$c2, 'change', eventListener);

    // Clean up the listener on unmount
    return function () {
      var _window$matchMedia3, _window3, _window$matchMedia3$c, _window$matchMedia3$c2;
      (_window$matchMedia3 = (_window3 = window).matchMedia) === null || _window$matchMedia3 === void 0 || (_window$matchMedia3$c = (_window$matchMedia3$c2 = _window$matchMedia3.call(_window3, COLOR_MODE_MEDIA_QUERY)).removeEventListener) === null || _window$matchMedia3$c === void 0 || _window$matchMedia3$c.call(_window$matchMedia3$c2, 'change', eventListener);
    };
  }, []);
  return children(systemColorMode);
};