import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["isHorizontal", "indicator", "alignIndicator", "accountForScrollbars", "className"],
  _excluded2 = ["registration", "id", "disabled", "onFocus"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useMemo, useRef, forwardRef } from 'react';
import classNames from 'classnames';
import { EuiI18n } from '../i18n';
import { useEuiMemoizedStyles, useGeneratedHtmlId } from '../../services';
import { useEuiResizableContainerContext } from './context';
import { euiResizableButtonStyles } from './resizable_button.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * A generic button for indicating/facilitating resizable content,
 * usable outside of the EuiResizableContainer context
 */
export var EuiResizableButton = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var isHorizontal = _ref.isHorizontal,
    _ref$indicator = _ref.indicator,
    indicator = _ref$indicator === void 0 ? 'handle' : _ref$indicator,
    _ref$alignIndicator = _ref.alignIndicator,
    alignIndicator = _ref$alignIndicator === void 0 ? 'center' : _ref$alignIndicator,
    accountForScrollbars = _ref.accountForScrollbars,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiResizableButton', className);
  var resizeDirection = isHorizontal ? 'horizontal' : 'vertical';
  var styles = useEuiMemoizedStyles(euiResizableButtonStyles);
  var cssStyles = [styles.euiResizableButton, styles[indicator], styles["".concat(indicator, "Direction")][resizeDirection], styles[resizeDirection], indicator === 'handle' && styles.alignIndicator[alignIndicator], styles.accountForScrollbars[resizeDirection][accountForScrollbars !== null && accountForScrollbars !== void 0 ? accountForScrollbars : 'none']];
  return ___EmotionJSX(EuiI18n, {
    tokens: ['euiResizableButton.horizontalResizerAriaLabel', 'euiResizableButton.verticalResizerAriaLabel'],
    defaults: ['Press the left or right arrow keys to adjust panels size', 'Press the up or down arrow keys to adjust panels size']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      horizontalResizerAriaLabel = _ref3[0],
      verticalResizerAriaLabel = _ref3[1];
    return ___EmotionJSX("button", _extends({
      ref: ref,
      "aria-label": isHorizontal ? horizontalResizerAriaLabel : verticalResizerAriaLabel,
      className: classes,
      css: cssStyles,
      "data-test-subj": "euiResizableButton",
      type: "button"
    }, rest));
  });
});
EuiResizableButton.displayName = 'EuiResizableButton';

/**
 * Resizer button specific to controlled EuiResizableContainer usage
 */

export var EuiResizableButtonControlled = function EuiResizableButtonControlled(_ref4) {
  var registration = _ref4.registration,
    id = _ref4.id,
    disabled = _ref4.disabled,
    _onFocus = _ref4.onFocus,
    rest = _objectWithoutProperties(_ref4, _excluded2);
  var resizerId = useGeneratedHtmlId({
    prefix: 'resizable-button',
    conditionalId: id
  });
  var _useEuiResizableConta = useEuiResizableContainerContext(),
    _useEuiResizableConta2 = _useEuiResizableConta.registry,
    _useEuiResizableConta3 = _useEuiResizableConta2 === void 0 ? {
      resizers: {}
    } : _useEuiResizableConta2,
    resizers = _useEuiResizableConta3.resizers;
  var isDisabled = useMemo(function () {
    var _resizers$resizerId;
    return disabled || ((_resizers$resizerId = resizers[resizerId]) === null || _resizers$resizerId === void 0 ? void 0 : _resizers$resizerId.isDisabled);
  }, [resizers, resizerId, disabled]);
  var previousRef = useRef();
  var onRef = useCallback(function (ref) {
    if (!registration) return;
    if (ref) {
      previousRef.current = ref;
      registration.register({
        id: resizerId,
        ref: ref,
        isFocused: false,
        isDisabled: disabled || false
      });
    } else {
      if (previousRef.current != null) {
        registration.deregister(resizerId);
        previousRef.current = undefined;
      }
    }
  }, [registration, resizerId, disabled]);
  return ___EmotionJSX(EuiResizableButton, _extends({
    id: resizerId,
    ref: onRef,
    disabled: isDisabled,
    onClick: function onClick(e) {
      return e.currentTarget.focus();
    },
    onFocus: function onFocus() {
      return _onFocus === null || _onFocus === void 0 ? void 0 : _onFocus(resizerId);
    }
  }, rest));
};
export var euiResizableButtonWithControls = function euiResizableButtonWithControls(controls) {
  return function (props) {
    return ___EmotionJSX(EuiResizableButtonControlled, _extends({}, controls, props));
  };
};