import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "externalPosition", "internalPosition", "direction", "isVisible", "isCollapsed"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiButtonIcon } from '../button';
import { euiScreenReaderOnlyStyles } from '../accessibility/screen_reader_only/screen_reader_only.styles';
import { euiResizableCollapseButtonStyles } from './resizable_collapse_button.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiResizableCollapseButton = function EuiResizableCollapseButton(_ref) {
  var className = _ref.className,
    _ref$externalPosition = _ref.externalPosition,
    externalPosition = _ref$externalPosition === void 0 ? 'before' : _ref$externalPosition,
    _ref$internalPosition = _ref.internalPosition,
    internalPosition = _ref$internalPosition === void 0 ? 'middle' : _ref$internalPosition,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'horizontal' : _ref$direction,
    isVisible = _ref.isVisible,
    isCollapsed = _ref.isCollapsed,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isHorizontal = direction === 'horizontal';
  var showOnFocus = !isCollapsed && !isVisible;
  var styles = useEuiMemoizedStyles(euiResizableCollapseButtonStyles);
  var collapsedStyles = [styles.collapsed.collapsed, styles.collapsed[direction], styles.collapsed["".concat(direction, "Positions")][internalPosition]];
  var collapsibleStyles = [styles.collapsible.collapsible, styles.collapsible[direction][externalPosition], styles.collapsible[direction][internalPosition]];
  var cssStyles = [styles.euiResizableCollapseButton, showOnFocus && euiScreenReaderOnlyStyles['euiScreenReaderOnly-showOnFocus']].concat(_toConsumableArray(isCollapsed ? collapsedStyles : collapsibleStyles));
  var COLLAPSED_ICON = '';
  var NOT_COLLAPSED_ICON = '';
  switch (externalPosition) {
    case 'before':
      COLLAPSED_ICON = isHorizontal ? 'menuLeft' : 'menuUp';
      NOT_COLLAPSED_ICON = isHorizontal ? 'menuRight' : 'menuDown';
      break;
    case 'after':
      COLLAPSED_ICON = isHorizontal ? 'menuRight' : 'menuDown';
      NOT_COLLAPSED_ICON = isHorizontal ? 'menuLeft' : 'menuUp';
      break;
  }
  var classes = classNames('euiResizableCollapseButton', className);
  return ___EmotionJSX(EuiButtonIcon, _extends({
    display: isCollapsed ? 'empty' : 'base',
    color: "text",
    className: classes,
    css: cssStyles
  }, rest, {
    iconType: isCollapsed ? COLLAPSED_ICON : NOT_COLLAPSED_ICON
  }));
};