import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["direction", "children", "className", "onPanelWidthChange", "onToggleCollapsed", "onResizeStart", "onResizeEnd"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useEffect, useRef, useCallback } from 'react';
import classNames from 'classnames';
import { keys, useLatest } from '../../services';
import { useResizeObserver } from '../observer/resize_observer';
import { EuiResizableContainerContextProvider } from './context';
import { euiResizableButtonWithControls } from './resizable_button';
import { euiResizablePanelWithControls, getModeType } from './resizable_panel';
import { useContainerCallbacks, getPosition } from './helpers';
import { euiResizableContainerStyles as styles } from './resizable_container.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var initialState = {
  isDragging: false,
  currentResizerPos: -1,
  prevPanelId: null,
  nextPanelId: null,
  containerSize: 1,
  panels: {},
  resizers: {}
};
export var EuiResizableContainer = function EuiResizableContainer(_ref) {
  var _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'horizontal' : _ref$direction,
    children = _ref.children,
    className = _ref.className,
    onPanelWidthChange = _ref.onPanelWidthChange,
    onToggleCollapsed = _ref.onToggleCollapsed,
    onResizeStart = _ref.onResizeStart,
    onResizeEnd = _ref.onResizeEnd,
    rest = _objectWithoutProperties(_ref, _excluded);
  // Note: It's important to memoize consumer callbacks to prevent our own functions
  // from reinstantiating unnecessarily & causing window event listeners to call stale closures
  var onResizeEndRef = useLatest(onResizeEnd);
  var onResizeStartRef = useLatest(onResizeStart);
  var containerRef = useRef(null);
  var isHorizontal = direction === 'horizontal';
  var classes = classNames('euiResizableContainer', className);
  var cssStyles = [styles.euiResizableContainer, styles[direction]];
  var _useContainerCallback = useContainerCallbacks({
      initialState: _objectSpread(_objectSpread({}, initialState), {}, {
        isHorizontal: isHorizontal
      }),
      containerRef: containerRef,
      onPanelWidthChange: onPanelWidthChange
    }),
    _useContainerCallback2 = _slicedToArray(_useContainerCallback, 2),
    actions = _useContainerCallback2[0],
    reducerState = _useContainerCallback2[1];
  var containerSize = useResizeObserver(containerRef.current, isHorizontal ? 'width' : 'height');
  var initialize = useCallback(function () {
    actions.initContainer(isHorizontal);
  }, [actions, isHorizontal]);
  useEffect(function () {
    if (containerSize.width > 0 && containerSize.height > 0) {
      initialize();
    }
  }, [initialize, containerSize]);
  var resizeContext = useRef({});
  var resizeEnd = useCallback(function () {
    var _onResizeEndRef$curre;
    (_onResizeEndRef$curre = onResizeEndRef.current) === null || _onResizeEndRef$curre === void 0 || _onResizeEndRef$curre.call(onResizeEndRef);
    resizeContext.current = {};
  }, [onResizeEndRef]);
  var resizeStart = useCallback(function (trigger, keyMoveDirection) {
    var _onResizeStartRef$cur;
    // If another resize starts while the previous one is still in progress
    // (e.g. user presses opposite arrow to change direction while the first
    // is still held down, or user presses an arrow while dragging with the
    // mouse), we want to signal the end of the previous resize first.
    if (resizeContext.current.trigger) {
      resizeEnd();
    }
    (_onResizeStartRef$cur = onResizeStartRef.current) === null || _onResizeStartRef$cur === void 0 || _onResizeStartRef$cur.call(onResizeStartRef, trigger);
    resizeContext.current = {
      trigger: trigger,
      keyMoveDirection: keyMoveDirection
    };
  }, [onResizeStartRef, resizeEnd]);
  var onMouseDown = useCallback(function (event) {
    var currentTarget = event.currentTarget;
    var prevPanel = currentTarget.previousElementSibling;
    var nextPanel = currentTarget.nextElementSibling;
    if (!prevPanel || !nextPanel) return;
    var prevPanelId = prevPanel.id;
    var nextPanelId = nextPanel.id;
    var position = getPosition(event, isHorizontal);
    resizeStart('pointer');
    actions.dragStart({
      position: position,
      prevPanelId: prevPanelId,
      nextPanelId: nextPanelId
    });

    // Window event listeners instead of React events are used to continue
    // detecting movement even if the user's mouse leaves the container

    var onMouseMove = function onMouseMove(event) {
      var position = getPosition(event, isHorizontal);
      actions.dragMove({
        position: position,
        prevPanelId: prevPanelId,
        nextPanelId: nextPanelId
      });
    };
    var onMouseUp = function onMouseUp() {
      if (resizeContext.current.trigger === 'pointer') {
        resizeEnd();
      }
      actions.reset();
      window.removeEventListener('mousemove', onMouseMove);
      window.removeEventListener('mouseup', onMouseUp);
      window.removeEventListener('touchmove', onMouseMove);
      window.removeEventListener('touchend', onMouseUp);
    };
    window.addEventListener('mousemove', onMouseMove);
    window.addEventListener('mouseup', onMouseUp);
    window.addEventListener('touchmove', onMouseMove);
    window.addEventListener('touchend', onMouseUp);
  }, [actions, isHorizontal, resizeStart, resizeEnd]);
  var getKeyMoveDirection = useCallback(function (key) {
    var direction = null;
    if (isHorizontal && key === keys.ARROW_LEFT || !isHorizontal && key === keys.ARROW_UP) {
      direction = 'backward';
    } else if (isHorizontal && key === keys.ARROW_RIGHT || !isHorizontal && key === keys.ARROW_DOWN) {
      direction = 'forward';
    }
    return direction;
  }, [isHorizontal]);
  var onKeyDown = useCallback(function (event) {
    var key = event.key,
      currentTarget = event.currentTarget;
    var direction = getKeyMoveDirection(key);
    var prevPanelId = currentTarget.previousElementSibling.id;
    var nextPanelId = currentTarget.nextElementSibling.id;
    if (direction && prevPanelId && nextPanelId) {
      if (!event.repeat) {
        resizeStart('key', direction);
      }
      event.preventDefault();
      actions.keyMove({
        direction: direction,
        prevPanelId: prevPanelId,
        nextPanelId: nextPanelId
      });
    }
  }, [actions, getKeyMoveDirection, resizeStart]);
  var onKeyUp = useCallback(function (_ref2) {
    var key = _ref2.key;
    // We only want to signal the end of a resize if the key that was released
    // is the same as the one that started the resize. This prevents the end
    // of a resize if the user presses one arrow key, then presses the opposite
    // arrow key to change direction, then releases the first arrow key.
    if (resizeContext.current.trigger === 'key' && resizeContext.current.keyMoveDirection === getKeyMoveDirection(key)) {
      resizeEnd();
    }
  }, [getKeyMoveDirection, resizeEnd]);
  var onBlur = useCallback(function () {
    if (resizeContext.current.trigger === 'key') {
      resizeEnd();
    }
    actions.resizerBlur();
  }, [actions, resizeEnd]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  var EuiResizableButton = useCallback(euiResizableButtonWithControls({
    onKeyDown: onKeyDown,
    onKeyUp: onKeyUp,
    onMouseDown: onMouseDown,
    onTouchStart: onMouseDown,
    onFocus: actions.resizerFocus,
    onBlur: onBlur,
    isHorizontal: isHorizontal,
    registration: {
      register: actions.registerResizer,
      deregister: actions.deregisterResizer
    }
  }), [actions, isHorizontal]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  var EuiResizablePanel = useCallback(euiResizablePanelWithControls({
    isHorizontal: isHorizontal,
    registration: {
      register: actions.registerPanel,
      deregister: actions.deregisterPanel
    },
    onToggleCollapsed: onToggleCollapsed,
    onToggleCollapsedInternal: actions.togglePanel
  }), [actions, isHorizontal]);
  var render = function render() {
    var DEFAULT = 'custom';
    var content = children(EuiResizablePanel, EuiResizableButton, {
      togglePanel: actions.togglePanel
    });
    var modes = /*#__PURE__*/React.isValidElement(content) ? content.props.children.map(function (el) {
      return getModeType(el.props.mode) || DEFAULT;
    }) : null;
    if (modes && (['collapsible', 'main'].every(function (i) {
      return modes.includes(i);
    }) || modes.every(function (i) {
      return i === DEFAULT;
    }))) {
      return content;
    } else {
      throw new Error('Both `collapsible` and `main` mode panels are required.');
    }
  };
  return ___EmotionJSX(EuiResizableContainerContextProvider, {
    registry: {
      panels: reducerState.panels,
      resizers: reducerState.resizers
    }
  }, ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes,
    ref: containerRef
  }, rest), render()));
};