/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { useCurrentEuiBreakpoint } from '../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiHideFor = function EuiHideFor(_ref) {
  var children = _ref.children,
    sizes = _ref.sizes;
  var currentBreakpoint = useCurrentEuiBreakpoint();
  var isWithinBreakpointSizes = currentBreakpoint && sizes.includes(currentBreakpoint);
  if (sizes === 'all' || isWithinBreakpointSizes) {
    return null;
  }
  return ___EmotionJSX(React.Fragment, null, children);
};