import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { dateFormat, dateGranularity } from './date_format';
import { isDateValue } from './date_value';
import { isArray, isBoolean, isNumber, isString, isDateLike, isNil } from '../../../services/predicate';
import moment from 'moment';
var utc = moment.utc;
var resolveValueAsDate = function resolveValueAsDate(value) {
  if (moment.isMoment(value)) {
    return value;
  }
  if (moment.isDate(value) || isNumber(value)) {
    return moment(value);
  }
  return dateFormat.parse(String(value));
};
var defaultEqOptions = {
  ignoreCase: true
};
export var eq = function eq(fieldValue, clauseValue) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  options = _objectSpread(_objectSpread({}, defaultEqOptions), options);
  if (isNil(fieldValue) || isNil(clauseValue)) {
    return fieldValue === clauseValue;
  }
  if (isBoolean(fieldValue)) {
    return clauseValue === fieldValue;
  }
  if (isArray(fieldValue)) {
    if (fieldValue.length > 0) {
      return fieldValue.some(function (item) {
        return eq(item, clauseValue, options);
      });
    } else {
      return eq('', clauseValue, options);
    }
  }
  if (isDateValue(clauseValue)) {
    var dateFieldValue = resolveValueAsDate(fieldValue);
    if (clauseValue.granularity) {
      return clauseValue.granularity.isSame(dateFieldValue, clauseValue.resolve());
    }
    return dateFieldValue.isSame(clauseValue.resolve());
  }
  if (isString(fieldValue)) {
    if (options.exactMatch === true) {
      return options.ignoreCase ? fieldValue.toLowerCase() === clauseValue.toString().toLowerCase() : fieldValue === clauseValue.toString();
    } else {
      return options.ignoreCase ? fieldValue.toLowerCase().includes(clauseValue.toString().toLowerCase()) : fieldValue.includes(clauseValue.toString());
    }
  }
  if (isNumber(fieldValue)) {
    clauseValue = Number(clauseValue);
    return fieldValue === clauseValue;
  }
  if (isDateLike(fieldValue)) {
    var date = resolveValueAsDate(clauseValue);
    if (!date.isValid()) {
      return false;
    }
    var granularity = dateGranularity(date);
    if (!granularity) {
      return utc(fieldValue).isSame(date);
    }
    return granularity.isSame(fieldValue, date);
  }
  return false; // unknown value type
};
export var exact = function exact(fieldValue, clauseValue) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  return eq(fieldValue, clauseValue, _objectSpread(_objectSpread({}, options), {}, {
    exactMatch: true
  }));
};
var greaterThen = function greaterThen(fieldValue, clauseValue) {
  var inclusive = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  if (isDateValue(clauseValue)) {
    var clauseDateValue = clauseValue.resolve();
    var fieldValueAsMomentInput = fieldValue;
    if (!clauseValue.granularity) {
      return inclusive ? utc(fieldValueAsMomentInput).isSameOrAfter(clauseDateValue) : utc(fieldValueAsMomentInput).isAfter(clauseDateValue);
    }
    if (inclusive) {
      return utc(fieldValueAsMomentInput).isSameOrAfter(clauseValue.granularity.start(clauseDateValue));
    }
    return utc(fieldValueAsMomentInput).isSameOrAfter(clauseValue.granularity.startOfNext(clauseDateValue));
  }
  if (isString(fieldValue)) {
    var str = String(clauseValue);
    return inclusive ? fieldValue >= str : fieldValue > str;
  }
  if (isNumber(fieldValue)) {
    var number = Number(clauseValue);
    return inclusive ? fieldValue >= number : fieldValue > number;
  }
  if (isDateLike(fieldValue)) {
    var date = resolveValueAsDate(clauseValue);
    var granularity = dateGranularity(date);
    if (!granularity) {
      return inclusive ? utc(fieldValue).isSameOrAfter(date) : utc(fieldValue).isAfter(date);
    }
    if (inclusive) {
      return utc(fieldValue).isSameOrAfter(granularity.start(date));
    }
    return utc(fieldValue).isSameOrAfter(granularity.startOfNext(date));
  }
  if (isArray(fieldValue)) {
    return fieldValue.every(function (item) {
      return greaterThen(item, clauseValue, inclusive);
    });
  }
  return false; // unsupported value type
};
export var gt = function gt(fieldValue, clauseValue) {
  if (isNil(fieldValue) || isNil(clauseValue)) {
    return false;
  }
  return greaterThen(fieldValue, clauseValue);
};
export var gte = function gte(fieldValue, clauseValue) {
  if (isNil(fieldValue) || isNil(clauseValue)) {
    return fieldValue === clauseValue;
  }
  return greaterThen(fieldValue, clauseValue, true);
};
export var lt = function lt(fieldValue, clauseValue) {
  if (isNil(fieldValue) || isNil(clauseValue)) {
    return false;
  }
  return !greaterThen(fieldValue, clauseValue, true);
};
export var lte = function lte(fieldValue, clauseValue) {
  if (isNil(fieldValue) || isNil(clauseValue)) {
    return fieldValue === clauseValue;
  }
  return !greaterThen(fieldValue, clauseValue);
};